/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public class FeatureCache
implements class_6910,
FunctionWithCache.Simple {
    public static final MapCodec<FeatureCache> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6910.field_37059.fieldOf("argument").forGetter(d -> d.argument), (App)class_6910.field_37059.optionalFieldOf("repeat_y").forGetter(d -> d.repeatY), (App)Codec.STRING.optionalFieldOf("key", (Object)"").forGetter(d -> d.key), (App)Codec.BOOL.optionalFieldOf("precomputed", (Object)false).forGetter(d -> d.precomputed)).apply((Applicative)instance, FeatureCache::new));
    public static final class_7243<FeatureCache> CODEC_HOLDER = class_7243.method_42116(CODEC);
    public final class_6910 argument;
    public final Optional<class_6910> repeatY;
    public final String key;
    public final boolean precomputed;
    private final Cache cache;

    private FeatureCache(class_6910 argument, Optional<class_6910> repeatY, String key, boolean precomputed, Cache cache) {
        this.argument = argument;
        this.key = key;
        this.repeatY = repeatY;
        this.cache = cache;
        this.precomputed = precomputed;
    }

    public FeatureCache(class_6910 argument, Optional<class_6910> repeatY, String key, boolean precomputed) {
        this.argument = argument;
        this.key = key.isEmpty() ? null : key;
        this.repeatY = repeatY;
        this.cache = null;
        this.precomputed = precomputed;
    }

    public double method_40464(class_6910.class_6912 pos) {
        boolean y2d = this.repeatY.isPresent();
        if (this.cache == null || pos.comp_371() < this.cache.minX || pos.comp_371() > this.cache.maxX || !y2d && (pos.comp_372() < this.cache.minY || pos.comp_372() > this.cache.maxY) || pos.comp_373() < this.cache.minZ || pos.comp_373() > this.cache.maxZ) {
            return this.sampleWithoutCache(pos);
        }
        int cacheX = pos.comp_371() - this.cache.minX;
        int cacheY = pos.comp_372() - this.cache.minY;
        int cacheZ = pos.comp_373() - this.cache.minZ;
        int idx = !y2d ? (this.cache.xExt * cacheY + cacheX) * this.cache.zExt + cacheZ : this.cache.zExt * cacheX + cacheZ;
        double cachedValue = this.cache.cache[idx];
        if (Double.isNaN(cachedValue)) {
            this.cache.cache[idx] = cachedValue = this.sampleWithoutCache(pos);
        }
        return cachedValue;
    }

    private double sampleWithoutCache(class_6910.class_6912 pos) {
        return this.argument.method_40464(pos);
    }

    public double comp_377() {
        return this.argument.comp_377();
    }

    public double comp_378() {
        return this.argument.comp_378();
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new FeatureCache(this.argument.method_40469(visitor), this.repeatY.map(d -> d.method_40469(visitor)), this.key, this.precomputed, this.cache));
    }

    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object createCache(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        double[] cache;
        int xExt = maxX - minX + 1;
        int yExt = maxY - minY + 1;
        int zExt = maxZ - minZ + 1;
        boolean y2d = this.repeatY.isPresent();
        int fixedY = y2d ? (int)this.repeatY.get().method_40464((class_6910.class_6912)new class_6910.class_6914(0, 0, 0)) : 0;
        double[] dArray = cache = y2d ? new double[(xExt + 2) * (zExt + 2)] : new double[(xExt + 2) * (yExt + 2) * (zExt + 2)];
        if (this.precomputed) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (y2d) {
                        cache[zExt * (x - minX) + z - minZ] = this.sampleWithoutCache((class_6910.class_6912)new class_6910.class_6914(x, fixedY, z));
                        continue;
                    }
                    for (int y = minY; y <= maxY; ++y) {
                        cache[(xExt * (y - minY) + x - minX) * zExt + z - minZ] = this.sampleWithoutCache((class_6910.class_6912)new class_6910.class_6914(x, y, z));
                    }
                }
            }
        } else {
            Arrays.fill(cache, Double.NaN);
        }
        return new Cache(cache, minX, maxX, minY, maxY, minZ, maxZ, xExt, zExt);
    }

    @Override
    public FunctionWithCache.Simple setCache(Object cache) {
        return new FeatureCache(this.argument, this.repeatY, this.key, this.precomputed, (Cache)cache);
    }

    private record Cache(double[] cache, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, int xExt, int zExt) {
    }
}

