/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.operations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public record Convolution(class_6910 input, List<Double> kernel, Double factor) implements class_6910
{
    public static final MapCodec<Convolution> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6910.field_37059.fieldOf("input").forGetter(Convolution::input), (App)Codec.DOUBLE.listOf().flatXmap(Convolution::checkKernelSize, Convolution::checkKernelSize).fieldOf("kernel").forGetter(Convolution::kernel), (App)Codec.DOUBLE.fieldOf("factor").forGetter(Convolution::factor)).apply((Applicative)instance, Convolution::new));
    public static final class_7243<Convolution> CODEC_HOLDER = class_7243.method_42116(CODEC);

    private static <T> DataResult<List<T>> checkKernelSize(List<T> k) {
        int sk = (int)Math.cbrt(k.size());
        return sk * sk * sk == k.size() && sk % 2 != 0 ? DataResult.success(k) : DataResult.error(() -> "The kernel length must be the cube of an odd number.");
    }

    public double method_40464(class_6910.class_6912 pos) {
        int k = (int)Math.cbrt(this.kernel.size());
        int off = k / 2;
        double acc = 0.0;
        for (int y = -off; y <= off; ++y) {
            for (int z = -off; z <= off; ++z) {
                for (int x = -off; x <= off; ++x) {
                    double f = this.kernel.get(k * k * (y + off) + k * (z + off) + x + off);
                    if (f == 0.0) continue;
                    acc += f * this.input.method_40464((class_6910.class_6912)new class_6910.class_6914(pos.comp_371() + x, pos.comp_372() + y, pos.comp_373() + z));
                }
            }
        }
        return acc * this.factor;
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new Convolution(this.input.method_40469(visitor), this.kernel, this.factor));
    }

    public double comp_377() {
        return this.input.comp_377();
    }

    public double comp_378() {
        return this.input.comp_378();
    }

    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }
}

