/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.utils.GaussianBlur;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class BorderBlurred
implements DensityFunction.SimpleFunction {
    private static final MapCodec<BorderBlurred> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("kernel_radius", (Object)3).forGetter(d -> d.kernelRadius), (App)Codec.DOUBLE.optionalFieldOf("sigma", (Object)2.0).forGetter(d -> d.sigma), (App)Codec.BOOL.optionalFieldOf("normalize", (Object)true).forGetter(d -> d.normalize)).apply((Applicative)instance, BorderBlurred::new));
    public static final KeyDispatchDataCodec<BorderBlurred> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    public final int kernelRadius;
    public final double sigma;
    public final boolean normalize;
    private double[][] blur = null;
    private boolean[][] isZero = null;
    private int minX;
    private int minZ;
    private int maxX;
    private int maxZ;
    public double minValue = 0.0;
    public double maxValue = 0.0;

    public BorderBlurred(int kernelRadius, double sigma, boolean normalize) {
        this.kernelRadius = kernelRadius;
        this.sigma = sigma;
        this.normalize = normalize;
    }

    public BorderBlurred create(boolean[][] isZero, int minX, int maxX, int minZ, int maxZ) {
        BorderBlurred copy = new BorderBlurred(this.kernelRadius, this.sigma, this.normalize);
        copy.isZero = isZero;
        copy.minX = minX;
        copy.maxX = maxX;
        copy.minZ = minZ;
        copy.maxZ = maxZ;
        return copy;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        if (this.blur == null && this.isZero != null) {
            int z;
            int x;
            double[][] value = new double[this.isZero.length][this.isZero[0].length];
            for (x = 0; x < this.isZero.length; ++x) {
                for (z = 0; z < this.isZero[0].length; ++z) {
                    value[x][z] = this.isZero[x][z] ? 0.0 : 1.0;
                }
            }
            this.blur = GaussianBlur.gaussianBlur(value, this.isZero, this.kernelRadius, this.sigma);
            this.maxValue = 0.0;
            this.minValue = 1.0;
            for (x = 0; x < this.blur.length; ++x) {
                for (z = 0; z < this.blur[0].length; ++z) {
                    this.maxValue = Math.max(this.blur[x][z], this.maxValue);
                    this.minValue = Math.min(this.blur[x][z], this.minValue);
                }
            }
        }
        if (this.blur == null) {
            return 0.0;
        }
        if (pos.blockX() < this.minX || pos.blockX() > this.maxX || pos.blockZ() < this.minZ || pos.blockZ() > this.maxZ) {
            return 0.0;
        }
        double val = this.blur[pos.blockX() - this.minX][pos.blockZ() - this.minZ];
        return this.normalize ? (val - this.minValue) / (this.maxValue - this.minValue) : val;
    }

    public double minValue() {
        return this.normalize ? 0.0 : this.minValue;
    }

    public double maxValue() {
        return this.normalize ? 1.0 : this.maxValue;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

