/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.utils.ChamferTransform;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class BorderChamferDistance
implements DensityFunction.SimpleFunction {
    private static final MapCodec<BorderChamferDistance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("normalize", (Object)true).forGetter(d -> d.normalize)).apply((Applicative)instance, BorderChamferDistance::new));
    public static final KeyDispatchDataCodec<BorderChamferDistance> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    public final boolean normalize;
    private double[][] dist = null;
    private boolean[][] isTarget = null;
    private int minX;
    private int minZ;
    private int maxX;
    private int maxZ;
    public double maxDist = 0.0;

    public BorderChamferDistance(boolean normalize) {
        this.normalize = normalize;
    }

    public BorderChamferDistance create(boolean[][] isTarget, int minX, int maxX, int minZ, int maxZ) {
        BorderChamferDistance copy = new BorderChamferDistance(this.normalize);
        copy.isTarget = isTarget;
        copy.minX = minX;
        copy.maxX = maxX;
        copy.minZ = minZ;
        copy.maxZ = maxZ;
        return copy;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        if (this.dist == null && this.isTarget != null) {
            this.dist = ChamferTransform.distanceTransform(this.isTarget);
            this.maxDist = 0.0;
            for (int x = 0; x < this.dist.length; ++x) {
                for (int z = 0; z < this.dist[0].length; ++z) {
                    double[] dArray = this.dist[x];
                    int n = z;
                    dArray[n] = dArray[n] / 2.0;
                    this.maxDist = Math.max(this.dist[x][z], this.maxDist);
                }
            }
        }
        if (this.dist == null) {
            return 0.0;
        }
        if (pos.blockX() < this.minX || pos.blockX() > this.maxX || pos.blockZ() < this.minZ || pos.blockZ() > this.maxZ) {
            return 0.0;
        }
        double val = this.dist[pos.blockX() - this.minX][pos.blockZ() - this.minZ];
        return this.normalize ? val / this.maxDist : val;
    }

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return this.normalize ? 1.0 : this.maxDist;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

