/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class FeatureCache
implements DensityFunction {
    public static final MapCodec<FeatureCache> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(d -> d.argument), (App)Codec.STRING.fieldOf("key").forGetter(d -> d.key), (App)Codec.BOOL.optionalFieldOf("y2d", (Object)false).forGetter(d -> d.y2d)).apply((Applicative)instance, FeatureCache::new));
    public static final KeyDispatchDataCodec<FeatureCache> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    public final DensityFunction argument;
    public final String key;
    public final boolean y2d;
    private final double[] cache;
    private final int cacheMinX;
    private final int cacheMaxX;
    private final int cacheMinY;
    private final int cacheMaxY;
    private final int cacheMinZ;
    private final int cacheMaxZ;
    private final int xExt;
    private final int zExt;

    public FeatureCache(DensityFunction argument, String key, boolean y2d, double[] cache, int cacheMinX, int cacheMaxX, int cacheMinY, int cacheMaxY, int cacheMinZ, int cacheMaxZ) {
        this.argument = argument;
        this.key = key;
        this.y2d = y2d;
        this.cache = cache;
        this.cacheMinX = cacheMinX;
        this.cacheMaxX = cacheMaxX;
        this.cacheMinY = cacheMinY;
        this.cacheMaxY = cacheMaxY;
        this.cacheMinZ = cacheMinZ;
        this.cacheMaxZ = cacheMaxZ;
        this.xExt = cacheMaxX - cacheMinX + 1;
        this.zExt = cacheMaxZ - cacheMinZ + 1;
    }

    public FeatureCache(DensityFunction argument, String key, boolean y2d) {
        this.argument = argument;
        this.key = key;
        this.y2d = y2d;
        this.cache = null;
        this.cacheMinX = 0;
        this.cacheMaxX = 0;
        this.cacheMinY = 0;
        this.cacheMaxY = 0;
        this.cacheMinZ = 0;
        this.cacheMaxZ = 0;
        this.xExt = 0;
        this.zExt = 0;
    }

    public FeatureCache create(double[] cache, int cacheMinX, int cacheMaxX, int cacheMinY, int cacheMaxY, int cacheMinZ, int cacheMaxZ) {
        Arrays.fill(cache, Double.NaN);
        return new FeatureCache(this.argument, this.key, this.y2d, cache, cacheMinX, cacheMaxX, cacheMinY, cacheMaxY, cacheMinZ, cacheMaxZ);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        if (this.cache == null || pos.blockX() < this.cacheMinX || pos.blockX() > this.cacheMaxX || !this.y2d && (pos.blockY() < this.cacheMinY || pos.blockY() > this.cacheMaxY) || pos.blockZ() < this.cacheMinZ || pos.blockZ() > this.cacheMaxZ) {
            return this.sampleWithoutCache(pos);
        }
        int cacheX = pos.blockX() - this.cacheMinX;
        int cacheY = pos.blockY() - this.cacheMinY;
        int cacheZ = pos.blockZ() - this.cacheMinZ;
        int idx = !this.y2d ? (this.xExt * cacheY + cacheX) * this.zExt + cacheZ : this.zExt * cacheX + cacheZ;
        double cachedValue = this.cache[idx];
        if (Double.isNaN(cachedValue)) {
            this.cache[idx] = cachedValue = this.sampleWithoutCache(pos);
        }
        return cachedValue;
    }

    private double sampleWithoutCache(DensityFunction.FunctionContext pos) {
        return this.argument.compute(pos);
    }

    public double minValue() {
        return this.argument.minValue();
    }

    public double maxValue() {
        return this.argument.maxValue();
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new FeatureCache(this.argument.mapAll(visitor), this.key, this.y2d, this.cache, this.cacheMinX, this.cacheMaxX, this.cacheMinY, this.cacheMaxY, this.cacheMinZ, this.cacheMaxZ));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

