/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class FeatureUserParameter
implements DensityFunction.SimpleFunction {
    public static final MapCodec<FeatureUserParameter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("parameter").forGetter(d -> d.parameter)).apply((Applicative)instance, FeatureUserParameter::new));
    public static final KeyDispatchDataCodec<FeatureUserParameter> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    private double value = Double.NaN;
    private double min = 0.0;
    private double max = 0.0;
    public final String parameter;

    public FeatureUserParameter(String parameter) {
        this.parameter = parameter;
    }

    public FeatureUserParameter create(double value) {
        FeatureUserParameter copy = new FeatureUserParameter(this.parameter);
        copy.value = value;
        copy.min = value;
        copy.max = value;
        return copy;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        if (Double.isNaN(this.value)) {
            System.out.println("Attempted to read unset user parameter: " + this.parameter);
        }
        return this.value;
    }

    public double minValue() {
        return this.min;
    }

    public double maxValue() {
        return this.max;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

