/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.utils.OpenSimplex2;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class Noise2D
implements DensityFunction {
    public static final MapCodec<Noise2D> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Codec.DOUBLE, (Codec)DensityFunction.HOLDER_HELPER_CODEC).fieldOf("xz_scale").forGetter(d -> d.xzScale), (App)Codec.LONG.optionalFieldOf("seed", (Object)0L).forGetter(d -> d.seed)).apply((Applicative)instance, Noise2D::new));
    public static final KeyDispatchDataCodec<Noise2D> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    public final Either<Double, DensityFunction> xzScale;
    public final long seed;
    private final double[][] cache;
    private final int cacheMinX;
    private final int cacheMaxX;
    private final int cacheMinZ;
    private final int cacheMaxZ;

    public Noise2D(Either<Double, DensityFunction> xzScale, long seed, double[][] cache, int cacheMinX, int cacheMaxX, int cacheMinZ, int cacheMaxZ) {
        this.xzScale = xzScale;
        this.seed = seed;
        this.cache = cache;
        this.cacheMinX = cacheMinX;
        this.cacheMaxX = cacheMaxX;
        this.cacheMinZ = cacheMinZ;
        this.cacheMaxZ = cacheMaxZ;
    }

    public Noise2D(Either<Double, DensityFunction> xzScale, long seed) {
        this.xzScale = xzScale;
        this.seed = seed;
        this.cache = null;
        this.cacheMinX = 0;
        this.cacheMaxX = 0;
        this.cacheMinZ = 0;
        this.cacheMaxZ = 0;
    }

    public Noise2D create(long featureSeed, double[][] cache, int cacheMinX, int cacheMaxX, int cacheMinZ, int cacheMaxZ) {
        for (int x = 0; x < cache.length; ++x) {
            for (int z = 0; z < cache[0].length; ++z) {
                cache[x][z] = Double.NaN;
            }
        }
        return new Noise2D(this.xzScale, this.seed + featureSeed, cache, cacheMinX, cacheMaxX, cacheMinZ, cacheMaxZ);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        int cacheZ;
        if (this.cache == null || pos.blockX() < this.cacheMinX || pos.blockX() > this.cacheMaxX || pos.blockZ() < this.cacheMinZ || pos.blockZ() > this.cacheMaxZ) {
            return this.sampleWithoutCache(pos);
        }
        int cacheX = pos.blockX() - this.cacheMinX;
        double cachedValue = this.cache[cacheX][cacheZ = pos.blockZ() - this.cacheMinZ];
        if (Double.isNaN(cachedValue)) {
            this.cache[cacheX][cacheZ] = cachedValue = (double)this.sampleWithoutCache(pos);
        }
        return cachedValue;
    }

    private float sampleWithoutCache(DensityFunction.FunctionContext pos) {
        double xzScale = (Double)this.xzScale.map(x -> x, d -> d.compute(pos));
        double x2 = (double)((long)pos.blockX() + (this.seed & 0xFFFFL)) * xzScale;
        double z = (double)((long)pos.blockZ() + (this.seed & 0xFFFFL)) * xzScale;
        return OpenSimplex2.noise2(this.seed, x2, z);
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Noise2D((Either<Double, DensityFunction>)this.xzScale.mapRight(d -> d.mapAll(visitor)), this.seed, this.cache, this.cacheMinX, this.cacheMaxX, this.cacheMinZ, this.cacheMaxZ));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

