/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.generation;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockTemplate {
    private static final Map<String, BlockTemplateType<?>> TEMPLATE_TYPES = new HashMap();
    private static final Codec<BlockTemplateType<?>> TEMPLATE_TYPE_CODEC = Codec.STRING.xmap(TEMPLATE_TYPES::get, BlockTemplateType::id);
    private static final Codec<BlockTemplate> RECORD_CODEC = TEMPLATE_TYPE_CODEC.dispatch("type", BlockTemplate::getType, BlockTemplateType::codec);
    public static final Codec<BlockTemplate> CODEC = Codec.either((Codec)Codec.STRING, RECORD_CODEC).xmap(either -> (BlockTemplate)either.map(BlockTemplate::parse, t -> t), template -> {
        Either either;
        if (template instanceof RandomChoiceParsing) {
            RandomChoiceParsing parsing = (RandomChoiceParsing)template;
            either = Either.left((Object)parsing.blockString);
        } else {
            either = Either.right((Object)template);
        }
        return either;
    });
    private static final BlockTemplateType<Simple> SIMPLE_TEMPLATE_TYPE = new BlockTemplateType("block", RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockState.CODEC.fieldOf("state").forGetter(t -> t.state)).apply((Applicative)instance, Simple::new)));
    private static final BlockTemplateType<SimpleParsing> SIMPLE_PARSING_TEMPLATE_TYPE = new BlockTemplateType("block_argument", RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("argument").forGetter(t -> t.blockString)).apply((Applicative)instance, SimpleParsing::new)));
    private static final BlockTemplateType<RandomChoiceParsing> RANDOM_PARSING_TEMPLATE_TYPE = new BlockTemplateType("random_block_argument", RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("argument").forGetter(t -> t.blockString)).apply((Applicative)instance, RandomChoiceParsing::new)));
    private static final BlockTemplateType<RandomChoice> RANDOM_CHOICE_TEMPLATE_TYPE = new BlockTemplateType("random", RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.listOf().fieldOf("choices").forGetter(t -> t.choices), (App)Codec.INT.fieldOf("emptyWeight").forGetter(t -> t.emptyWeight)).apply((Applicative)instance, RandomChoice::new)));

    public abstract BlockState getBlockState(WorldGenLevel var1, RandomSource var2, Map<String, BlockTemplate> var3);

    public abstract void process(WorldGenLevel var1, RandomSource var2, BlockPos var3, Direction var4);

    public abstract Collection<String> getReferencedPaletteEntries();

    public abstract BlockTemplate copy();

    public static BlockTemplate empty() {
        return new Simple(null);
    }

    public static BlockTemplate block(BlockState state) {
        return new Simple(state);
    }

    public static BlockTemplate block(Block block) {
        return BlockTemplate.block(block.defaultBlockState());
    }

    public static BlockTemplate parse(String blockArgument) {
        return new RandomChoiceParsing(blockArgument);
    }

    public static BlockTemplate random(BlockState[] states) {
        return new RandomChoice(Arrays.stream(states).map(Simple::new).map(s -> s).toList(), 0);
    }

    public static BlockTemplate random(BlockState[] states, int emptyWeight) {
        return new RandomChoice(Arrays.stream(states).map(Simple::new).map(s -> s).toList(), emptyWeight);
    }

    public abstract BlockTemplateType<?> getType();

    static {
        TEMPLATE_TYPES.put(BlockTemplate.SIMPLE_TEMPLATE_TYPE.id, SIMPLE_TEMPLATE_TYPE);
        TEMPLATE_TYPES.put(BlockTemplate.RANDOM_CHOICE_TEMPLATE_TYPE.id, RANDOM_CHOICE_TEMPLATE_TYPE);
    }

    private static class Simple
    extends BlockTemplate {
        private final BlockState state;

        public Simple(BlockState state) {
            this.state = state;
        }

        @Override
        public BlockState getBlockState(WorldGenLevel world, RandomSource random, Map<String, BlockTemplate> palette) {
            return this.state;
        }

        @Override
        public void process(WorldGenLevel world, RandomSource random, BlockPos pos, Direction direction) {
        }

        @Override
        public Collection<String> getReferencedPaletteEntries() {
            return List.of();
        }

        @Override
        public BlockTemplate copy() {
            return new Simple(this.state);
        }

        @Override
        public BlockTemplateType<?> getType() {
            return SIMPLE_TEMPLATE_TYPE;
        }
    }

    private static class RandomChoiceParsing
    extends BlockTemplate {
        private final String blockString;
        private BlockTemplate template = null;
        private boolean parseAttempt = false;
        private HashSet<String> referencedPaletteEntries = null;

        public RandomChoiceParsing(String blockString) {
            this.blockString = blockString;
        }

        @Override
        public BlockState getBlockState(WorldGenLevel world, RandomSource random, Map<String, BlockTemplate> palette) {
            if (!this.parseAttempt && this.template == null) {
                this.parseAttempt = true;
                this.parse(palette);
            }
            return this.template == null ? null : this.template.getBlockState(world, random, palette);
        }

        private void parse(Map<String, BlockTemplate> palette) {
            this.referencedPaletteEntries = new HashSet();
            String[] options = this.blockString.split(";");
            if (options.length == 1) {
                this.template = new SimpleParsing(this.blockString);
                this.referencedPaletteEntries.addAll(this.template.getReferencedPaletteEntries());
            } else {
                ArrayList<BlockTemplate> templates = new ArrayList<BlockTemplate>();
                int emptyWeight = 0;
                for (String arg : options) {
                    if (arg.isEmpty() || arg.equals("*")) {
                        ++emptyWeight;
                        continue;
                    }
                    if (arg.startsWith("%?")) {
                        String reference = arg.substring(2);
                        this.referencedPaletteEntries.add(reference);
                        BlockTemplate subTemplate = palette.get(reference);
                        if (subTemplate == null) continue;
                        templates.add(subTemplate);
                        continue;
                    }
                    SimpleParsing subTemplate = new SimpleParsing(arg);
                    templates.add(subTemplate);
                    this.referencedPaletteEntries.addAll(subTemplate.getReferencedPaletteEntries());
                }
                this.template = new RandomChoice(templates, emptyWeight);
            }
        }

        @Override
        public void process(WorldGenLevel world, RandomSource random, BlockPos pos, Direction direction) {
        }

        @Override
        public Collection<String> getReferencedPaletteEntries() {
            return Collections.emptySet();
        }

        @Override
        public BlockTemplate copy() {
            return new RandomChoiceParsing(this.blockString);
        }

        @Override
        public BlockTemplateType<?> getType() {
            return RANDOM_PARSING_TEMPLATE_TYPE;
        }
    }

    private static class RandomChoice
    extends BlockTemplate {
        private final List<BlockTemplate> choices;
        private final int emptyWeight;

        public RandomChoice(List<BlockTemplate> choices, int emptyWeight) {
            this.choices = choices;
            this.emptyWeight = emptyWeight;
        }

        @Override
        public BlockState getBlockState(WorldGenLevel world, RandomSource random, Map<String, BlockTemplate> palette) {
            int choice = random.nextInt(this.choices.size() + this.emptyWeight);
            return choice < this.choices.size() ? this.choices.get(choice).getBlockState(world, random, palette) : null;
        }

        @Override
        public void process(WorldGenLevel world, RandomSource random, BlockPos pos, Direction direction) {
        }

        @Override
        public Collection<String> getReferencedPaletteEntries() {
            return this.choices.stream().flatMap(t -> t.getReferencedPaletteEntries().stream()).collect(Collectors.toSet());
        }

        @Override
        public BlockTemplate copy() {
            return new RandomChoice(this.choices, this.emptyWeight);
        }

        @Override
        public BlockTemplateType<?> getType() {
            return RANDOM_CHOICE_TEMPLATE_TYPE;
        }
    }

    private static class SimpleParsing
    extends BlockTemplate {
        private final String blockString;
        private BlockState state = null;
        private boolean parseAttempt = false;

        public SimpleParsing(String blockString) {
            this.blockString = blockString;
        }

        @Override
        public BlockState getBlockState(WorldGenLevel world, RandomSource random, Map<String, BlockTemplate> palette) {
            if (!this.parseAttempt && this.state == null) {
                this.parseAttempt = true;
                try {
                    if (Objects.equals(this.blockString, "*")) {
                        this.state = null;
                    } else if (this.blockString.startsWith("%")) {
                        this.state = palette.getOrDefault(this.blockString.substring(1), new Simple(null)).getBlockState(world, random, palette);
                    } else {
                        BlockStateParser.BlockResult result = BlockStateParser.parseForBlock((HolderLookup)world.holderLookup(Registries.BLOCK), (String)this.blockString, (boolean)false);
                        this.state = result.blockState();
                    }
                }
                catch (CommandSyntaxException e) {
                    return null;
                }
            }
            return this.state;
        }

        @Override
        public void process(WorldGenLevel world, RandomSource random, BlockPos pos, Direction direction) {
        }

        @Override
        public Collection<String> getReferencedPaletteEntries() {
            return this.blockString.startsWith("%*") ? List.of(this.blockString.substring(2)) : List.of();
        }

        @Override
        public BlockTemplate copy() {
            return new SimpleParsing(this.blockString);
        }

        @Override
        public BlockTemplateType<?> getType() {
            return SIMPLE_PARSING_TEMPLATE_TYPE;
        }
    }

    public record BlockTemplateType<T extends BlockTemplate>(String id, MapCodec<T> codec) {
    }
}

