/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_5819;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public class FeatureRandomGrid
implements class_6910,
FunctionWithCache {
    public static final MapCodec<FeatureRandomGrid> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6910.field_37059.fieldOf("min").forGetter(d -> d.min), (App)class_6910.field_37059.fieldOf("max").forGetter(d -> d.max), (App)class_6910.field_37059.optionalFieldOf("mean").forGetter(d -> d.mean), (App)class_6910.field_37059.optionalFieldOf("std").forGetter(d -> d.std), (App)Codec.BOOL.optionalFieldOf("integer", (Object)true).forGetter(d -> d.integer), (App)Codec.either((Codec)Codec.LONG, (Codec)Codec.STRING).xmap(e -> (Long)e.map(l -> l, s -> s.hashCode()), Either::left).fieldOf("seed").forGetter(d -> d.seed)).apply((Applicative)instance, FeatureRandomGrid::new));
    public static final class_7243<FeatureRandomGrid> CODEC_HOLDER = class_7243.method_42116(CODEC);
    public final class_6910 min;
    public final class_6910 max;
    public final Optional<class_6910> mean;
    public final Optional<class_6910> std;
    public final boolean integer;
    public final long seed;
    private final Cache cache;

    private FeatureRandomGrid(class_6910 min, class_6910 max, Optional<class_6910> mean, Optional<class_6910> std, boolean integer, long seed, Cache cache) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.std = std;
        this.integer = integer;
        this.seed = seed;
        this.cache = cache;
    }

    public FeatureRandomGrid(class_6910 min, class_6910 max, Optional<class_6910> mean, Optional<class_6910> std, boolean integer, long seed) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.std = std;
        this.integer = integer;
        this.seed = seed;
        this.cache = null;
    }

    public double method_40464(class_6910.class_6912 pos) {
        double value;
        if (this.cache == null) {
            throw new RuntimeException("FeatureRandomCreed sampled outside of the feature type.");
        }
        class_5819 random = class_5819.method_43049((long)(this.seed + this.cache.featureSeed + (long)new class_2338(pos.comp_371(), pos.comp_372(), pos.comp_373()).hashCode()));
        if (this.cache.min > this.cache.max) {
            value = this.cache.min;
        } else if (this.std.isPresent()) {
            value = random.method_43059() * this.cache.std + (this.cache.max + this.cache.min) / 2.0;
            value = Math.min(this.cache.max, Math.max(this.cache.min, value));
            if (this.integer) {
                value = Math.round(value);
            }
        } else {
            value = this.integer ? (double)random.method_39332((int)this.cache.min, (int)this.cache.max) : random.method_43058() * (this.cache.max - this.cache.min) + this.cache.min;
        }
        return value;
    }

    public double comp_377() {
        return this.cache == null ? Double.NEGATIVE_INFINITY : this.cache.min;
    }

    public double comp_378() {
        return this.cache == null ? Double.POSITIVE_INFINITY : this.cache.max;
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new FeatureRandomGrid(this.min.method_40469(visitor), this.max.method_40469(visitor), this.mean.map(f -> f.method_40469(visitor)), this.std.map(f -> f.method_40469(visitor)), this.integer, this.seed, this.cache));
    }

    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }

    public FeatureRandomGrid create(long featureSeed) {
        double minValue = this.min.method_40464((class_6910.class_6912)new class_6910.class_6914(0, 0, 0));
        double maxValue = this.max.method_40464((class_6910.class_6912)new class_6910.class_6914(0, 0, 0));
        double stdValue = this.std.map(s -> s.method_40464((class_6910.class_6912)new class_6910.class_6914(0, 0, 0))).orElse(0.0);
        double meanValue = this.mean.map(m -> m.method_40464((class_6910.class_6912)new class_6910.class_6914(0, 0, 0))).orElse((maxValue + minValue) / 2.0);
        return new FeatureRandomGrid(this.min, this.max, this.mean, this.std, this.integer, this.seed, new Cache(featureSeed, minValue, maxValue, meanValue, stdValue));
    }

    @Override
    public String key() {
        return "__feature_random_grid_" + this.seed;
    }

    @Override
    public FunctionWithCache setCache(Object cache) {
        return new FeatureRandomGrid(this.min, this.max, this.mean, this.std, this.integer, this.seed, (Cache)cache);
    }

    public Object getCache() {
        return this.cache;
    }

    private record Cache(long featureSeed, double min, double max, double mean, double std) {
    }
}

