/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.algorithms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.utils.OpenSimplex2;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class Noise3D
implements DensityFunction.SimpleFunction {
    public static final MapCodec<Noise3D> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Codec.DOUBLE, (Codec)DensityFunction.HOLDER_HELPER_CODEC).fieldOf("xz_scale").forGetter(d -> d.xzScale), (App)Codec.either((Codec)Codec.DOUBLE, (Codec)DensityFunction.HOLDER_HELPER_CODEC).fieldOf("y_scale").forGetter(d -> d.yScale), (App)Codec.either((Codec)Codec.LONG, (Codec)Codec.STRING).xmap(e -> (Long)e.map(l -> l, s -> s.hashCode()), Either::left).optionalFieldOf("seed", (Object)0L).forGetter(d -> d.seed)).apply((Applicative)instance, Noise3D::new));
    public static final KeyDispatchDataCodec<Noise3D> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    public final Either<Double, DensityFunction> xzScale;
    public final Either<Double, DensityFunction> yScale;
    public final long seed;

    public Noise3D(Either<Double, DensityFunction> xzScale, Either<Double, DensityFunction> yScale, long seed) {
        this.xzScale = xzScale;
        this.yScale = yScale;
        this.seed = seed;
    }

    public Noise3D create(long featureSeed) {
        return new Noise3D(this.xzScale, this.yScale, this.seed + featureSeed);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        double xzScale = (Double)this.xzScale.map(x -> x, d -> d.compute(pos));
        double yScale = (Double)this.yScale.map(x -> x, d -> d.compute(pos));
        double x2 = (double)((long)pos.blockX() + (this.seed & 0xFFFFL)) * xzScale;
        double y = (double)((long)pos.blockY() + (this.seed & 0xFFFFL)) * yScale;
        double z = (double)((long)pos.blockZ() + (this.seed & 0xFFFFL)) * xzScale;
        return OpenSimplex2.noise3_ImproveXZ(this.seed, x2, y, z);
    }

    public double minValue() {
        return -1.0;
    }

    public double maxValue() {
        return 1.0;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Noise3D((Either<Double, DensityFunction>)this.xzScale.mapRight(d -> d.mapAll(visitor)), (Either<Double, DensityFunction>)this.yScale.mapRight(d -> d.mapAll(visitor)), this.seed));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

