/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;

public class FeatureRandomGrid
implements DensityFunction,
FunctionWithCache {
    public static final MapCodec<FeatureRandomGrid> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min").forGetter(d -> d.min), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max").forGetter(d -> d.max), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("mean").forGetter(d -> d.mean), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("std").forGetter(d -> d.std), (App)Codec.BOOL.optionalFieldOf("integer", (Object)true).forGetter(d -> d.integer), (App)Codec.either((Codec)Codec.LONG, (Codec)Codec.STRING).xmap(e -> (Long)e.map(l -> l, s -> s.hashCode()), Either::left).fieldOf("seed").forGetter(d -> d.seed)).apply((Applicative)instance, FeatureRandomGrid::new));
    public static final KeyDispatchDataCodec<FeatureRandomGrid> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    public final DensityFunction min;
    public final DensityFunction max;
    public final Optional<DensityFunction> mean;
    public final Optional<DensityFunction> std;
    public final boolean integer;
    public final long seed;
    private final Cache cache;

    private FeatureRandomGrid(DensityFunction min, DensityFunction max, Optional<DensityFunction> mean, Optional<DensityFunction> std, boolean integer, long seed, Cache cache) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.std = std;
        this.integer = integer;
        this.seed = seed;
        this.cache = cache;
    }

    public FeatureRandomGrid(DensityFunction min, DensityFunction max, Optional<DensityFunction> mean, Optional<DensityFunction> std, boolean integer, long seed) {
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.std = std;
        this.integer = integer;
        this.seed = seed;
        this.cache = null;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        double value;
        if (this.cache == null) {
            throw new RuntimeException("FeatureRandomCreed sampled outside of the feature type.");
        }
        RandomSource random = RandomSource.create((long)(this.seed + this.cache.featureSeed + (long)new BlockPos(pos.blockX(), pos.blockY(), pos.blockZ()).hashCode()));
        if (this.cache.min > this.cache.max) {
            value = this.cache.min;
        } else if (this.std.isPresent()) {
            value = random.nextGaussian() * this.cache.std + (this.cache.max + this.cache.min) / 2.0;
            value = Math.min(this.cache.max, Math.max(this.cache.min, value));
            if (this.integer) {
                value = Math.round(value);
            }
        } else {
            value = this.integer ? (double)random.nextIntBetweenInclusive((int)this.cache.min, (int)this.cache.max) : random.nextDouble() * (this.cache.max - this.cache.min) + this.cache.min;
        }
        return value;
    }

    public double minValue() {
        return this.cache == null ? Double.NEGATIVE_INFINITY : this.cache.min;
    }

    public double maxValue() {
        return this.cache == null ? Double.POSITIVE_INFINITY : this.cache.max;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new FeatureRandomGrid(this.min.mapAll(visitor), this.max.mapAll(visitor), this.mean.map(f -> f.mapAll(visitor)), this.std.map(f -> f.mapAll(visitor)), this.integer, this.seed, this.cache));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }

    public FeatureRandomGrid create(long featureSeed) {
        double minValue = this.min.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
        double maxValue = this.max.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
        double stdValue = this.std.map(s -> s.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0))).orElse(0.0);
        double meanValue = this.mean.map(m -> m.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0))).orElse((maxValue + minValue) / 2.0);
        return new FeatureRandomGrid(this.min, this.max, this.mean, this.std, this.integer, this.seed, new Cache(featureSeed, minValue, maxValue, meanValue, stdValue));
    }

    @Override
    public String key() {
        return "__feature_random_grid_" + this.seed;
    }

    @Override
    public FunctionWithCache setCache(Object cache) {
        return new FeatureRandomGrid(this.min, this.max, this.mean, this.std, this.integer, this.seed, (Cache)cache);
    }

    public Object getCache() {
        return this.cache;
    }

    private record Cache(long featureSeed, double min, double max, double mean, double std) {
    }
}

