/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.operations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Convolution(DensityFunction input, List<Double> kernel, Double factor) implements DensityFunction
{
    public static final MapCodec<Convolution> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(Convolution::input), (App)Codec.DOUBLE.listOf().validate(k -> {
        int sk = (int)Math.cbrt(k.size());
        return sk * sk * sk == k.size() && sk % 2 != 0 ? DataResult.success((Object)k) : DataResult.error(() -> "The kernel length must be the cube of an odd number.");
    }).fieldOf("kernel").forGetter(Convolution::kernel), (App)Codec.DOUBLE.fieldOf("factor").forGetter(Convolution::factor)).apply((Applicative)instance, Convolution::new));
    public static final KeyDispatchDataCodec<Convolution> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    public double compute(DensityFunction.FunctionContext pos) {
        int k = (int)Math.cbrt(this.kernel.size());
        int off = k / 2;
        double acc = 0.0;
        for (int y = -off; y <= off; ++y) {
            for (int z = -off; z <= off; ++z) {
                for (int x = -off; x <= off; ++x) {
                    double f = this.kernel.get(k * k * (y + off) + k * (z + off) + x + off);
                    if (f == 0.0) continue;
                    acc += f * this.input.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.blockX() + x, pos.blockY() + y, pos.blockZ() + z));
                }
            }
        }
        return acc * this.factor;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Convolution(this.input.mapAll(visitor), this.kernel, this.factor));
    }

    public double minValue() {
        return this.input.minValue();
    }

    public double maxValue() {
        return this.input.maxValue();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

