/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.operations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record MinAlongY(DensityFunction argument, DensityFunction minY, DensityFunction maxY) implements DensityFunction
{
    public static final MapCodec<MinAlongY> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(MinAlongY::argument), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min_y").forGetter(MinAlongY::minY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max_y").forGetter(MinAlongY::maxY)).apply((Applicative)instance, MinAlongY::new));
    public static final KeyDispatchDataCodec<MinAlongY> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    public double compute(DensityFunction.FunctionContext pos) {
        double min = Double.POSITIVE_INFINITY;
        for (int y = (int)this.minY.compute(pos); y <= (int)this.maxY.compute(pos); ++y) {
            min = Math.min(min, this.argument.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.blockX(), y, pos.blockZ())));
        }
        return min;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new MinAlongY(this.argument.mapAll(visitor), this.minY.mapAll(visitor), this.maxY.mapAll(visitor)));
    }

    public double minValue() {
        return this.argument.minValue();
    }

    public double maxValue() {
        return Double.POSITIVE_INFINITY;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

