/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.BoundedFunction;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Cuboid(DensityFunction _minX, DensityFunction _maxX, DensityFunction _minY, DensityFunction _maxY, DensityFunction _minZ, DensityFunction _maxZ, DensityFunction inside) implements DensityFunction,
BoundedFunction
{
    public static final MapCodec<Cuboid> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min_x").forGetter(Cuboid::_minX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max_x").forGetter(Cuboid::_maxX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min_y").forGetter(Cuboid::_minY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max_y").forGetter(Cuboid::_maxY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min_z").forGetter(Cuboid::_minZ), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max_z").forGetter(Cuboid::_maxZ), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("inside").forGetter(Cuboid::inside)).apply((Applicative)instance, Cuboid::new));
    public static final KeyDispatchDataCodec<Cuboid> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double compute(DensityFunction.FunctionContext pos) {
        DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(0, 0, 0);
        if (!((double)pos.blockX() >= this._minX.compute((DensityFunction.FunctionContext)singlePointContext))) return 0.0;
        DensityFunction.SinglePointContext singlePointContext2 = new DensityFunction.SinglePointContext(0, 0, 0);
        if (!((double)pos.blockX() <= this._maxX.compute((DensityFunction.FunctionContext)singlePointContext2))) return 0.0;
        DensityFunction.SinglePointContext singlePointContext3 = new DensityFunction.SinglePointContext(0, 0, 0);
        if (!((double)pos.blockY() >= this._minY.compute((DensityFunction.FunctionContext)singlePointContext3))) return 0.0;
        DensityFunction.SinglePointContext singlePointContext4 = new DensityFunction.SinglePointContext(0, 0, 0);
        if (!((double)pos.blockY() <= this._maxY.compute((DensityFunction.FunctionContext)singlePointContext4))) return 0.0;
        DensityFunction.SinglePointContext singlePointContext5 = new DensityFunction.SinglePointContext(0, 0, 0);
        if (!((double)pos.blockZ() >= this._minZ.compute((DensityFunction.FunctionContext)singlePointContext5))) return 0.0;
        DensityFunction.SinglePointContext singlePointContext6 = new DensityFunction.SinglePointContext(0, 0, 0);
        if (!((double)pos.blockZ() <= this._maxZ.compute((DensityFunction.FunctionContext)singlePointContext6))) return 0.0;
        double d = this.inside.compute(pos);
        return d;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Cuboid(this._minX.mapAll(visitor), this._maxX.mapAll(visitor), this._minY.mapAll(visitor), this._maxY.mapAll(visitor), this._minZ.mapAll(visitor), this._maxZ.mapAll(visitor), this.inside.mapAll(visitor)));
    }

    public double minValue() {
        return Math.min(0.0, this.inside.minValue());
    }

    public double maxValue() {
        return Math.max(0.0, this.inside.maxValue());
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }

    @Override
    public int minX() {
        return (int)this._minX.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
    }

    @Override
    public int maxX() {
        return (int)this._maxX.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
    }

    @Override
    public int minY() {
        return (int)this._minY.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
    }

    @Override
    public int maxY() {
        return (int)this._maxY.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
    }

    @Override
    public int minZ() {
        return (int)this._minZ.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
    }

    @Override
    public int maxZ() {
        return (int)this._maxZ.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
    }
}

