/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.features.Generator;
import io.github.orlouge.landmarks.features.Palette;
import io.github.orlouge.landmarks.features.Parameter;
import io.github.orlouge.landmarks.features.VariantContext;
import io.github.orlouge.landmarks.features.VariantWithFragment;
import io.github.orlouge.landmarks.generation.BlockTemplate;
import io.github.orlouge.landmarks.utils.RandomProperty;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class SurfaceNoiseFeature
extends Feature<Config> {
    public SurfaceNoiseFeature(Codec<Config> configCodec) {
        super(configCodec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        WorldGenLevel world = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        Holder biome = context.level().getBiome(origin);
        ChunkPos originChunk = new ChunkPos(origin);
        long seed = random.nextLong();
        random = RandomSource.create((long)seed);
        long startTime = System.currentTimeMillis();
        int minZ = (originChunk.z - 1) * 16;
        int maxZ = (originChunk.z + 2) * 16 - 1;
        int minX = (originChunk.x - 1) * 16;
        int maxX = (originChunk.x + 2) * 16 - 1;
        int minY = world.getMinY();
        int maxY = world.getMaxY();
        try {
            Generator baseGenerator;
            Config config = (Config)context.config();
            boolean debug = config.debug;
            if (debug) {
                System.out.println("#################################");
                context.topFeature().flatMap(arg_0 -> ((Registry)world.registryAccess().lookupOrThrow(Registries.CONFIGURED_FEATURE)).getResourceKey(arg_0)).ifPresentOrElse(k -> System.out.println("Generating configured feature " + String.valueOf(k.location())), () -> System.out.println("Generating surface noise feature"));
                System.out.println("  at " + String.valueOf(origin) + " (" + biome.getRegisteredName() + ") with seed " + seed);
            }
            BlockPos minPos = new BlockPos(minX, minY, minZ);
            BlockPos maxPos = new BlockPos(maxX, maxY, maxZ);
            VariantContext variantContext = new VariantContext(world, seed, (Holder<Biome>)biome, new HashMap<String, String>(), origin, minPos, maxPos, new HashMap<String, Parameter.Sampler>(), new HashMap<String, Object>(), new Palette());
            VariantWithFragment.VariantSampler<Generator.RandomizedGeneratorConfig> variantSampler = new VariantWithFragment.VariantSampler<Generator.RandomizedGeneratorConfig>();
            variantSampler.addUnconditionalSubvariants(config.baseGenerator);
            variantContext = variantSampler.sampleContext(random, variantContext);
            if (debug) {
                this.printContext("(Base)", variantContext);
            }
            if ((baseGenerator = config.baseGenerator.fragment().sample(random, variantContext)).abort()) {
                if (debug) {
                    this.printContext("(Aborted)", variantContext.withParameters(baseGenerator.parameters()));
                }
                return false;
            }
            if (!baseGenerator.skip()) {
                variantContext = baseGenerator.generate(world, random, variantContext);
            }
            DensityFunction.Visitor visitor = variantContext.getVisitor();
            if (config.bounds.isPresent()) {
                Parameter.Sampler sampler = (Parameter.Sampler)config.bounds.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor));
                if (sampler.bounds().isPresent()) {
                    minZ = Math.max(minZ, sampler.bounds().get().minZ());
                    maxZ = Math.min(maxZ, sampler.bounds().get().maxZ());
                    minX = Math.max(minX, sampler.bounds().get().minX());
                    maxX = Math.min(maxX, sampler.bounds().get().maxX());
                    minY = Math.max(minY, sampler.bounds().get().minY());
                    maxY = Math.min(maxY, sampler.bounds().get().maxY());
                } else {
                    int _minX = maxX;
                    int _maxX = minX;
                    int _minY = maxY;
                    int _maxY = minY;
                    int _minZ = maxZ;
                    int _maxZ = minZ;
                    for (int x = minX; x <= maxX; ++x) {
                        for (int y = minY; y <= maxY; ++y) {
                            for (int z = minZ; z < maxZ; ++z) {
                                DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(x, y, z);
                                if (!(sampler.sample((DensityFunction.FunctionContext)singlePointContext) > 0.0)) continue;
                                if (x < _minX) {
                                    _minX = x;
                                }
                                if (x > _maxX) {
                                    _maxX = x;
                                }
                                if (y < _minY) {
                                    _minY = y;
                                }
                                if (y > _maxY) {
                                    _maxY = y;
                                }
                                if (z < _minZ) {
                                    _minZ = z;
                                }
                                if (z <= _maxZ) continue;
                                _maxZ = z;
                            }
                        }
                    }
                    minX = _minX;
                    minY = _minY;
                    minZ = _minZ;
                    maxX = _maxX;
                    maxY = _maxY;
                    maxZ = _maxZ;
                }
            }
            DensityFunction.SinglePointContext zeroPos = new DensityFunction.SinglePointContext(0, 0, 0);
            if (config.minX.isPresent()) {
                minX = Math.max(minX, (int)((Parameter.Sampler)config.minX.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((DensityFunction.FunctionContext)zeroPos));
            }
            if (config.minY.isPresent()) {
                minY = Math.max(minY, (int)((Parameter.Sampler)config.minY.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((DensityFunction.FunctionContext)zeroPos));
            }
            if (config.minZ.isPresent()) {
                minZ = Math.max(minZ, (int)((Parameter.Sampler)config.minZ.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((DensityFunction.FunctionContext)zeroPos));
            }
            if (config.maxX.isPresent()) {
                maxX = Math.min(maxX, (int)((Parameter.Sampler)config.maxX.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((DensityFunction.FunctionContext)zeroPos));
            }
            if (config.maxY.isPresent()) {
                maxY = Math.min(maxY, (int)((Parameter.Sampler)config.maxY.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((DensityFunction.FunctionContext)zeroPos));
            }
            if (config.maxZ.isPresent()) {
                maxZ = Math.min(maxZ, (int)((Parameter.Sampler)config.maxZ.get().map(variantContext.userParameters()::get, p -> p.createSampler(visitor))).sample((DensityFunction.FunctionContext)zeroPos));
            }
            variantContext = variantContext.withBounds(minX, minY, minZ, maxX, maxY, maxZ);
            for (Either<ResourceLocation, VariantWithFragment<Generator.RandomizedGeneratorConfig>> referenceOrGenerator : config.generators) {
                Generator generator;
                if (debug) {
                    this.printContext((String)referenceOrGenerator.map(ResourceLocation::toString, r -> "(Anonymous)"), variantContext);
                }
                if (referenceOrGenerator.left().isPresent()) {
                    Tuple<Generator.RandomizedGeneratorConfig, VariantContext> pair = Generator.RandomizedGeneratorConfig.getAndMerge(List.of((ResourceLocation)referenceOrGenerator.left().get()), new Generator.RandomizedGeneratorConfig(), random, variantContext, world.registryAccess());
                    variantContext = (VariantContext)pair.getB();
                    generator = ((Generator.RandomizedGeneratorConfig)pair.getA()).sample(random, variantContext);
                } else {
                    VariantWithFragment randomGen = (VariantWithFragment)referenceOrGenerator.right().get();
                    VariantWithFragment.VariantSampler sampler = new VariantWithFragment.VariantSampler();
                    sampler.addUnconditionalSubvariants(randomGen);
                    variantContext = sampler.sampleContext(random, variantContext);
                    generator = ((Generator.RandomizedGeneratorConfig)randomGen.fragment()).sample(random, variantContext);
                }
                if (generator.abort()) {
                    if (debug) {
                        this.printContext("(Aborted)", variantContext.withParameters(generator.parameters()));
                    }
                    return false;
                }
                if (generator.skip()) {
                    if (!debug) continue;
                    System.out.println("Skipped");
                    continue;
                }
                variantContext = generator.generate(world, random, variantContext);
            }
            if (debug) {
                this.printContext("(Exiting)", variantContext);
            }
            if (debug) {
                System.out.println("Generated in " + (System.currentTimeMillis() - startTime) + " ms");
                System.out.println("#################################\n\n");
            }
        }
        catch (RandomProperty.NoRandomMatchException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private void printContext(String generator, VariantContext variantContext) {
        System.out.println("Context for " + generator + ":");
        System.out.println("  Bounds: " + String.valueOf(variantContext.minPos()) + " -> " + String.valueOf(variantContext.maxPos()));
        if (!variantContext.variant().isEmpty()) {
            System.out.println("  Variants: " + String.join((CharSequence)", ", variantContext.variant().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toList()));
        }
        if (!variantContext.userParameters().isEmpty()) {
            try {
                System.out.println("  Parameters: " + String.join((CharSequence)", ", variantContext.userParameters().entrySet().stream().map(e -> {
                    Object value;
                    try {
                        Object patt0$temp = e.getValue();
                        if (patt0$temp instanceof Parameter.Constant) {
                            Parameter.Constant cons = (Parameter.Constant)patt0$temp;
                            value = "" + cons.value;
                            if (((String)value).length() > 7) {
                                value = String.format("%.3f", cons.value);
                            }
                        } else {
                            double val;
                            double min = Double.POSITIVE_INFINITY;
                            double max = Double.NEGATIVE_INFINITY;
                            double mean = 0.0;
                            double cnt = 0.0;
                            double std = 0.0;
                            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)variantContext.minPos(), (BlockPos)variantContext.maxPos())) {
                                val = ((Parameter.Sampler)e.getValue()).sample((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ()));
                                min = Math.min(val, min);
                                max = Math.max(val, max);
                                mean += val;
                                cnt += 1.0;
                            }
                            mean /= cnt;
                            if (max - min < 1.0E-4) {
                                value = "" + mean;
                                if (((String)value).length() > 7) {
                                    value = String.format("%.3f", mean);
                                }
                            } else {
                                for (BlockPos pos : BlockPos.betweenClosed((BlockPos)variantContext.minPos(), (BlockPos)variantContext.maxPos())) {
                                    val = ((Parameter.Sampler)e.getValue()).sample((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ()));
                                    std += (val - mean) * (val - mean);
                                }
                                std = Math.sqrt(std / cnt);
                                value = String.format("%.3f\u00b1%.2f \u2208 [%.2f,%.2f]", mean, std, min, max);
                            }
                        }
                    }
                    catch (Exception ex) {
                        value = ex.getMessage();
                    }
                    return (String)e.getKey() + " = " + (String)value;
                }).toList()));
            }
            catch (Exception ex) {
                System.out.println("  Parameters: ERROR");
                ex.printStackTrace();
            }
        }
        if (!variantContext.palette().entries().isEmpty() || !variantContext.palette().copiedEntries().isEmpty()) {
            System.out.println("  Palette: " + String.join((CharSequence)", ", variantContext.palette().entries().entrySet().stream().map(e -> (String)e.getKey() + " = " + ((BlockTemplate)e.getValue()).toString()).toList()) + " | " + String.join((CharSequence)",", variantContext.palette().copiedEntries().keySet()));
        }
    }

    public record Config(List<Either<ResourceLocation, VariantWithFragment<Generator.RandomizedGeneratorConfig>>> generators, VariantWithFragment<Generator.RandomizedGeneratorConfig> baseGenerator, Optional<Either<String, Parameter>> minX, Optional<Either<String, Parameter>> minY, Optional<Either<String, Parameter>> minZ, Optional<Either<String, Parameter>> maxX, Optional<Either<String, Parameter>> maxY, Optional<Either<String, Parameter>> maxZ, Optional<Either<String, Parameter>> bounds, boolean debug) implements FeatureConfiguration
    {
        public static final MapCodec<Config> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)ResourceLocation.CODEC, (Codec)Generator.RandomizedGeneratorConfig.VARIANT_MAP_CODEC.codec()).listOf().optionalFieldOf("generators", Collections.emptyList()).forGetter(Config::generators), (App)Generator.RandomizedGeneratorConfig.VARIANT_MAP_CODEC.forGetter(Config::baseGenerator), (App)Parameter.CODEC_NAMED.optionalFieldOf("min_x").forGetter(Config::minX), (App)Parameter.CODEC_NAMED.optionalFieldOf("min_y").forGetter(Config::minY), (App)Parameter.CODEC_NAMED.optionalFieldOf("min_z").forGetter(Config::minZ), (App)Parameter.CODEC_NAMED.optionalFieldOf("max_x").forGetter(Config::maxX), (App)Parameter.CODEC_NAMED.optionalFieldOf("max_y").forGetter(Config::maxY), (App)Parameter.CODEC_NAMED.optionalFieldOf("max_z").forGetter(Config::maxZ), (App)Parameter.CODEC_NAMED.optionalFieldOf("bounds").forGetter(Config::bounds), (App)Codec.BOOL.optionalFieldOf("debug", (Object)false).forGetter(Config::debug)).apply((Applicative)instance, Config::new));
    }
}

