/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.algorithms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import io.github.orlouge.landmarks.utils.ChamferTransform;
import java.util.Optional;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class ChamferDistanceTransform
implements FunctionWithCache.Simple {
    private static final MapCodec<ChamferDistanceTransform> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("normalize", (Object)true).forGetter(d -> d.normalize), (App)Codec.STRING.optionalFieldOf("key", (Object)"").forGetter(d -> d.key), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(d -> d.argument), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min_x").forGetter(d -> d.minX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min_z").forGetter(d -> d.minZ), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max_x").forGetter(d -> d.maxX), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max_z").forGetter(d -> d.maxZ), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("y").forGetter(d -> d.y)).apply((Applicative)instance, ChamferDistanceTransform::new));
    public static final KeyDispatchDataCodec<ChamferDistanceTransform> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    public final boolean normalize;
    public final String key;
    public final DensityFunction argument;
    public final DensityFunction minX;
    public final DensityFunction minZ;
    public final DensityFunction maxX;
    public final DensityFunction maxZ;
    public final Optional<DensityFunction> y;
    private final Cache cache;

    public ChamferDistanceTransform(boolean normalize, String key, DensityFunction argument, DensityFunction minX, DensityFunction minZ, DensityFunction maxX, DensityFunction maxZ, Optional<DensityFunction> y) {
        this.normalize = normalize;
        this.key = key.isEmpty() ? null : key;
        this.argument = argument;
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.y = y;
        this.cache = null;
    }

    private ChamferDistanceTransform(boolean normalize, String key, DensityFunction argument, DensityFunction minX, DensityFunction minZ, DensityFunction maxX, DensityFunction maxZ, Optional<DensityFunction> y, Cache cache) {
        this.normalize = normalize;
        this.key = key;
        this.argument = argument;
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.y = y;
        this.cache = cache;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        if (pos.blockX() < this.cache.minX || pos.blockX() > this.cache.maxX || pos.blockZ() < this.cache.minZ || pos.blockZ() > this.cache.maxZ) {
            return 0.0;
        }
        double val = this.cache.dist[pos.blockX() - this.cache.minX][pos.blockZ() - this.cache.minZ];
        return this.normalize ? val / this.cache.maxDist : val;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new ChamferDistanceTransform(this.normalize, this.key, this.argument.mapAll(visitor), this.minX.mapAll(visitor), this.minZ.mapAll(visitor), this.maxX.mapAll(visitor), this.maxZ.mapAll(visitor), this.y, this.cache));
    }

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return this.normalize || this.cache == null ? 1.0 : this.cache.maxDist;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object createCache(int _minX, int _maxX, int _minY, int _maxY, int _minZ, int _maxZ) {
        int y = (int)this.y.map(d -> d.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0))).orElse(0.0).doubleValue();
        int minX = (int)this.minX.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, y, 0));
        int maxX = (int)this.maxX.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, y, 0));
        int minZ = (int)this.minZ.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, y, 0));
        int maxZ = (int)this.maxZ.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, y, 0));
        int extX = maxX - minX + 1;
        int extZ = maxZ - minZ + 1;
        boolean[][] isZero = new boolean[extX][extZ];
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                isZero[x - minX][z - minZ] = this.argument.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z)) <= 0.0;
            }
        }
        double[][] dist = ChamferTransform.distanceTransform(isZero);
        double maxDist = 0.0;
        for (int x = 0; x < dist.length; ++x) {
            for (int z = 0; z < dist[0].length; ++z) {
                double[] dArray = dist[x];
                int n = z;
                dArray[n] = dArray[n] / 2.0;
                maxDist = Math.max(dist[x][z], maxDist);
            }
        }
        return new Cache(dist, maxDist > 0.0 ? maxDist : 1.0, minX, maxX, minZ, maxZ);
    }

    @Override
    public FunctionWithCache.Simple setCache(Object cache) {
        return new ChamferDistanceTransform(this.normalize, this.key, this.argument, this.minX, this.minZ, this.maxX, this.maxZ, this.y, (Cache)cache);
    }

    private record Cache(double[][] dist, double maxDist, int minX, int maxX, int minZ, int maxZ) {
    }
}

