/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.BoundedFunction;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class FeatureMass
implements DensityFunction,
FunctionWithCache.Simple {
    public static final MapCodec<FeatureMass> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(d -> d.argument), (App)Codec.STRING.optionalFieldOf("key", (Object)"").forGetter(d -> d.key)).apply((Applicative)instance, FeatureMass::new));
    public static final KeyDispatchDataCodec<FeatureMass> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    public final DensityFunction argument;
    public final String key;
    private final Cache cache;

    private FeatureMass(DensityFunction argument, String key, Cache cache) {
        this.argument = argument;
        this.key = key;
        this.cache = cache;
    }

    public FeatureMass(DensityFunction argument, String key) {
        this.argument = argument;
        this.key = key.isEmpty() ? null : key;
        this.cache = null;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        if (this.cache == null) {
            throw new RuntimeException("FeatureMass sampled outside of the feature type.");
        }
        return this.cache.value;
    }

    public double minValue() {
        return this.cache == null ? Double.NEGATIVE_INFINITY : this.cache.value;
    }

    public double maxValue() {
        return this.cache == null ? Double.POSITIVE_INFINITY : this.cache.value;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new FeatureMass(this.argument.mapAll(visitor), this.key, this.cache));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object createCache(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        double value = 0.0;
        DensityFunction densityFunction = this.argument;
        if (densityFunction instanceof BoundedFunction) {
            BoundedFunction maskBounds = (BoundedFunction)densityFunction;
            minZ = Math.max(minZ, maskBounds.minZ());
            maxZ = Math.min(maxZ, maskBounds.maxZ());
            minX = Math.max(minX, maskBounds.minX());
            maxX = Math.min(maxX, maskBounds.maxX());
            minY = Math.max(minY, maskBounds.minY());
            maxY = Math.min(maxY, maskBounds.maxY());
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    value += this.argument.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z));
                }
            }
        }
        return new Cache(value);
    }

    @Override
    public FunctionWithCache.Simple setCache(Object cache) {
        return new FeatureMass(this.argument, this.key, (Cache)cache);
    }

    private record Cache(double value) {
    }
}

