/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.operations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Map(DensityFunction value, Optional<DensityFunction> x, Optional<DensityFunction> y, Optional<DensityFunction> z) implements DensityFunction
{
    public static final MapCodec<Map> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(Map::value), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("x").forGetter(Map::x), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("y").forGetter(Map::y), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("z").forGetter(Map::z)).apply((Applicative)instance, Map::new));
    public static final KeyDispatchDataCodec<Map> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    public double compute(DensityFunction.FunctionContext pos) {
        return this.value.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(this.x.map(f -> (int)Math.round(f.compute(pos))).orElse(pos.blockX()).intValue(), this.y.map(f -> (int)Math.round(f.compute(pos))).orElse(pos.blockY()).intValue(), this.z.map(f -> (int)Math.round(f.compute(pos))).orElse(pos.blockZ()).intValue()));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Map(this.value.mapAll(visitor), this.x.map(d -> d.mapAll(visitor)), this.y.map(d -> d.mapAll(visitor)), this.z.map(d -> d.mapAll(visitor))));
    }

    public double minValue() {
        return this.value.minValue();
    }

    public double maxValue() {
        return this.value.maxValue();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

