/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.BoundedFunction;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Cylinder(DensityFunction x, DensityFunction z, DensityFunction _minY, DensityFunction _maxY, DensityFunction _radius, DensityFunction inside) implements DensityFunction,
BoundedFunction
{
    public static final MapCodec<Cylinder> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("x").forGetter(Cylinder::x), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("z").forGetter(Cylinder::z), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min_y").forGetter(Cylinder::_minY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max_y").forGetter(Cylinder::_maxY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("radius").forGetter(Cylinder::_radius), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("inside").forGetter(Cylinder::inside)).apply((Applicative)instance, Cylinder::new));
    public static final KeyDispatchDataCodec<Cylinder> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double compute(DensityFunction.FunctionContext pos) {
        DensityFunction.SinglePointContext singlePointContext = new DensityFunction.SinglePointContext(0, 0, 0);
        DensityFunction.SinglePointContext singlePointContext2 = new DensityFunction.SinglePointContext(0, 0, 0);
        DensityFunction.SinglePointContext singlePointContext3 = new DensityFunction.SinglePointContext(0, 0, 0);
        if (!(Math.sqrt(Math.pow((double)pos.blockX() - this.x.compute((DensityFunction.FunctionContext)singlePointContext), 2.0) + Math.pow((double)pos.blockZ() - this.z.compute((DensityFunction.FunctionContext)singlePointContext2), 2.0)) <= this._radius.compute((DensityFunction.FunctionContext)singlePointContext3))) return 0.0;
        DensityFunction.SinglePointContext singlePointContext4 = new DensityFunction.SinglePointContext(0, 0, 0);
        if (!((double)pos.blockY() >= this._minY.compute((DensityFunction.FunctionContext)singlePointContext4))) return 0.0;
        DensityFunction.SinglePointContext singlePointContext5 = new DensityFunction.SinglePointContext(0, 0, 0);
        if (!((double)pos.blockY() <= this._maxY.compute((DensityFunction.FunctionContext)singlePointContext5))) return 0.0;
        double d = this.inside.compute(pos);
        return d;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Cylinder(this.x.mapAll(visitor), this.z.mapAll(visitor), this._minY.mapAll(visitor), this._maxY.mapAll(visitor), this._radius.mapAll(visitor), this.inside.mapAll(visitor)));
    }

    public double minValue() {
        return Math.min(0.0, this.inside.minValue());
    }

    public double maxValue() {
        return Math.max(0.0, this.inside.maxValue());
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }

    @Override
    public int minX() {
        return (int)(this.x.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) - this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)));
    }

    @Override
    public int maxX() {
        return (int)(this.x.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) + this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)));
    }

    @Override
    public int minY() {
        return (int)this._minY.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
    }

    @Override
    public int maxY() {
        return (int)this._maxY.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
    }

    @Override
    public int minZ() {
        return (int)(this.z.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) - this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)));
    }

    @Override
    public int maxZ() {
        return (int)(this.z.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) + this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)));
    }
}

