/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.LandmarksMod;
import io.github.orlouge.landmarks.density.BoundedFunction;
import io.github.orlouge.landmarks.features.Palette;
import io.github.orlouge.landmarks.features.Parameter;
import io.github.orlouge.landmarks.features.VariantContext;
import io.github.orlouge.landmarks.generation.BlockTemplate;
import io.github.orlouge.landmarks.utils.RandomProperty;
import io.github.orlouge.landmarks.utils.RandomWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.DensityFunction;

public record ProcessingStep(Parameter.Sampler mask, Map<String, Parameter.Sampler> localParameters, boolean xAscending, boolean yAscending, boolean zAscending, List<Rule> rules) {
    public void process(WorldGenLevel world, RandomSource random, VariantContext context) {
        if (this.rules.isEmpty()) {
            return;
        }
        VariantContext localContext = context.withParameters(this.localParameters);
        Optional<BoundedFunction> maskBounds = this.mask.bounds();
        int minX = localContext.minPos().getX();
        int minY = localContext.minPos().getY();
        int minZ = localContext.minPos().getZ();
        int maxX = localContext.maxPos().getX();
        int maxY = localContext.maxPos().getY();
        int maxZ = localContext.maxPos().getZ();
        if (maskBounds.isPresent()) {
            minZ = Math.max(minZ, maskBounds.get().minZ());
            maxZ = Math.min(maxZ, maskBounds.get().maxZ());
            minX = Math.max(minX, maskBounds.get().minX());
            maxX = Math.min(maxX, maskBounds.get().maxX());
            minY = Math.max(minY, maskBounds.get().minY());
            maxY = Math.min(maxY, maskBounds.get().maxY());
        }
        for (int _z = 0; _z <= maxZ - minZ; ++_z) {
            for (int _x = 0; _x <= maxX - minX; ++_x) {
                for (int _y = 0; _y <= maxY - minY; ++_y) {
                    int x = this.xAscending ? minX + _x : maxX - _x;
                    int y = this.yAscending ? minY + _y : maxY - _y;
                    int z = this.zAscending ? minZ + _z : maxZ - _z;
                    if (this.mask.sample((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z)) <= 0.0) continue;
                    BlockPos pos = new BlockPos(x, y, z);
                    DensityFunction.SinglePointContext noisePos = new DensityFunction.SinglePointContext(x, y, z);
                    HashMap copiedEntries = new HashMap();
                    BiFunction<String, Boolean, BlockTemplate> palette = (entry, strict) -> (BlockTemplate)localContext.palette().get((String)entry, (boolean)strict).map(actualTemplate -> actualTemplate, resolved -> copiedEntries.computeIfAbsent(entry, entry2 -> ProcessingStep.copyBlock(world, resolved, noisePos)));
                    for (Rule rule : this.rules) {
                        if (rule.process(pos, (Holder<Block>)world.getBlockState(pos).getBlockHolder(), palette, world, random, localContext)) break;
                    }
                }
            }
        }
    }

    private static BlockTemplate copyBlock(WorldGenLevel world, Palette.ResolvedCopiedEntry resolved, DensityFunction.SinglePointContext noisePos) {
        int x = (int)resolved.x().sample((DensityFunction.FunctionContext)noisePos);
        int y = (int)resolved.y().sample((DensityFunction.FunctionContext)noisePos);
        int z = (int)resolved.z().sample((DensityFunction.FunctionContext)noisePos);
        BlockState state = world.getBlockState(new BlockPos(x, y, z));
        if (!resolved.canCopy().contains(state.getBlockHolder())) {
            return BlockTemplate.empty();
        }
        if (resolved.resetState()) {
            state = state.getBlock().defaultBlockState();
        }
        return BlockTemplate.block(state);
    }

    public record Rule(Either<BlockTemplate, Palette.ResolvedCopiedEntry> template, boolean postProcessing, boolean autoWaterlog, boolean passThroughIfNotReplaced, boolean impossible, Optional<HolderSet<Block>> blockBelow, Optional<HolderSet<Block>> blockBeingReplaced, Optional<HolderSet<Block>> blockAbove, Either<TagKey<Block>, HolderSet<Block>> cantReplace, List<Parameter.Condition> densityConditions) {
        public static Rule sampleAll(RandomizedRule rule, RandomSource random, VariantContext context) throws RandomProperty.NoRandomMatchException {
            Optional<HolderSet<Block>> blockBelow = Optional.empty();
            Optional<HolderSet<Block>> blockBeingReplaced = Optional.empty();
            Optional<HolderSet<Block>> blockAbove = Optional.empty();
            ArrayList<Parameter.Condition> conditions = new ArrayList<Parameter.Condition>();
            if (rule.blockBelow.isPresent()) {
                blockBelow = Optional.of(rule.blockBelow.get().sample(random, context));
            }
            if (rule.blockBeingReplaced.isPresent()) {
                blockBeingReplaced = Optional.of(rule.blockBeingReplaced.get().sample(random, context));
            }
            if (rule.blockAbove.isPresent()) {
                blockAbove = Optional.of(rule.blockAbove.get().sample(random, context));
            }
            Either cantReplace = rule.cantReplace.left().isPresent() ? Either.left((Object)((TagKey)rule.cantReplace.left().get())) : Either.right((Object)((HolderSet)((RandomProperty)rule.cantReplace().right().get()).sample(random, context)));
            for (RandomProperty<String, VariantContext, VariantContext.Predicate> condition : rule.densityConditions.sample(random, context)) {
                conditions.add(Parameter.Condition.parse(condition.sample(random, context), context.userParameters()));
            }
            Either template = null;
            try {
                template = (Either)rule.template.sample(random, context).referenceOrTemplate().map(context.palette()::get, t -> Either.left((Object)t.copy()));
            }
            catch (RandomProperty.NoRandomMatchException noRandomMatchException) {
                // empty catch block
            }
            return new Rule((Either<BlockTemplate, Palette.ResolvedCopiedEntry>)template, rule.postProcessing, rule.autoWaterlog, rule.passThroughIfNotReplaced, rule.impossible, blockBelow, blockBeingReplaced, blockAbove, (Either<TagKey<Block>, HolderSet<Block>>)cantReplace, conditions);
        }

        public boolean process(BlockPos pos, Holder<Block> currentBlock, BiFunction<String, Boolean, BlockTemplate> palette, WorldGenLevel world, RandomSource random, VariantContext context) {
            BlockState blockToPlace;
            if (this.impossible) {
                return false;
            }
            if (this.blockAbove.isPresent() && !this.blockAbove.get().contains(world.getBlockState(pos.offset(0, 1, 0)).getBlockHolder())) {
                return false;
            }
            if (this.blockBelow.isPresent() && !this.blockBelow.get().contains(world.getBlockState(pos.offset(0, -1, 0)).getBlockHolder())) {
                return false;
            }
            if (this.blockBeingReplaced.isPresent() && !this.blockBeingReplaced.get().contains(currentBlock)) {
                return false;
            }
            if (((Boolean)this.cantReplace.map(arg_0 -> currentBlock.is(arg_0), list -> list.contains(currentBlock))).booleanValue()) {
                return false;
            }
            DensityFunction.SinglePointContext noisePos = new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ());
            for (Parameter.Condition condition : this.densityConditions) {
                if (condition.test((DensityFunction.FunctionContext)noisePos)) continue;
                return false;
            }
            BlockState blockState = blockToPlace = this.template == null ? null : (BlockState)this.template.map(template2 -> template2.getBlockState(world, random, palette), resolved -> ProcessingStep.copyBlock(world, resolved, noisePos).getBlockState(world, random, palette));
            if (blockToPlace != null) {
                if (this.autoWaterlog && currentBlock.value() == Blocks.WATER && blockToPlace.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                    blockToPlace = (BlockState)blockToPlace.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                if (!this.postProcessing) {
                    LandmarksMod.DISABLE_POST_PROCESSING_ONCE = true;
                }
                world.setBlock(pos, blockToPlace, 2);
                return true;
            }
            return !this.passThroughIfNotReplaced;
        }

        public record RandomizedRule(RandomProperty<Palette.PalettedBlockTemplate, VariantContext, VariantContext.Predicate> template, boolean postProcessing, boolean autoWaterlog, boolean passThroughIfNotReplaced, boolean impossible, Optional<RandomProperty<HolderSet<Block>, VariantContext, VariantContext.Predicate>> blockBelow, Optional<RandomProperty<HolderSet<Block>, VariantContext, VariantContext.Predicate>> blockBeingReplaced, Optional<RandomProperty<HolderSet<Block>, VariantContext, VariantContext.Predicate>> blockAbove, Either<TagKey<Block>, RandomProperty<HolderSet<Block>, VariantContext, VariantContext.Predicate>> cantReplace, RandomProperty<List<RandomProperty<String, VariantContext, VariantContext.Predicate>>, VariantContext, VariantContext.Predicate> densityConditions) {
            public static final MapCodec<RandomizedRule> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)VariantContext.wrappedRandomCodec(Palette.PalettedBlockTemplate.CODEC, "block").optionalFieldOf("place", VariantContext.defaultRandomProperty(new Palette.PalettedBlockTemplate((Either<String, BlockTemplate>)Either.right((Object)BlockTemplate.empty())))).forGetter(RandomizedRule::template), (App)Codec.BOOL.optionalFieldOf("post_processing", (Object)true).forGetter(RandomizedRule::postProcessing), (App)Codec.BOOL.optionalFieldOf("auto_waterlog", (Object)false).forGetter(RandomizedRule::autoWaterlog), (App)Codec.BOOL.optionalFieldOf("pass_through_if_not_replaced", (Object)false).forGetter(RandomizedRule::passThroughIfNotReplaced), (App)Codec.BOOL.optionalFieldOf("impossible", (Object)false).forGetter(RandomizedRule::impossible), (App)VariantContext.strictWrappedRandomCodec(RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK), "blocks").optionalFieldOf("block_below_is").forGetter(RandomizedRule::blockBelow), (App)VariantContext.strictWrappedRandomCodec(RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK), "blocks").optionalFieldOf("block_is").forGetter(RandomizedRule::blockBeingReplaced), (App)VariantContext.strictWrappedRandomCodec(RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK), "blocks").optionalFieldOf("block_above_is").forGetter(RandomizedRule::blockAbove), (App)Codec.either((Codec)TagKey.hashedCodec((ResourceKey)Registries.BLOCK), VariantContext.strictWrappedRandomCodec(RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK), "blocks")).optionalFieldOf("cant_replace", (Object)Either.left((Object)BlockTags.FEATURES_CANNOT_REPLACE)).forGetter(RandomizedRule::cantReplace), (App)VariantContext.strictWrappedRandomCodec(VariantContext.strictWrappedRandomCodec(Codec.STRING).listOf(), "conditions").optionalFieldOf("conditions", VariantContext.defaultRandomProperty(List.of())).forGetter(RandomizedRule::densityConditions)).apply((Applicative)instance, RandomizedRule::new));
        }
    }

    public record RandomizedProcessingStep(Optional<Integer> index, RandomProperty<Either<String, Parameter>, VariantContext, VariantContext.Predicate> mask, Map<String, RandomProperty<Parameter, VariantContext, VariantContext.Predicate>> localParameters, List<RandomProperty<Rule.RandomizedRule, VariantContext, VariantContext.Predicate>> rules, RandomProperty<Boolean, VariantContext, VariantContext.Predicate> xAscending, RandomProperty<Boolean, VariantContext, VariantContext.Predicate> yAscending, RandomProperty<Boolean, VariantContext, VariantContext.Predicate> zAscending) implements RandomWrapper<ProcessingStep, VariantContext>
    {
        public static final MapCodec<RandomizedProcessingStep> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("index").forGetter(RandomizedProcessingStep::index), (App)VariantContext.wrappedRandomCodec(Parameter.CODEC_NAMED, "parameter").optionalFieldOf("mask", VariantContext.defaultRandomProperty(Either.right((Object)new Parameter.Constant(1.0)))).forGetter(RandomizedProcessingStep::mask), (App)Codec.unboundedMap((Codec)Codec.STRING, VariantContext.wrappedRandomCodec(Parameter.CODEC)).optionalFieldOf("parameters", Collections.emptyMap()).forGetter(RandomizedProcessingStep::localParameters), (App)VariantContext.strictWrappedRandomCodec(Rule.RandomizedRule.CODEC.codec(), "rule").listOf().fieldOf("rules").forGetter(RandomizedProcessingStep::rules), (App)VariantContext.wrappedRandomCodec(Codec.BOOL).optionalFieldOf("x_ascending", VariantContext.defaultRandomProperty(true)).forGetter(RandomizedProcessingStep::xAscending), (App)VariantContext.wrappedRandomCodec(Codec.BOOL).optionalFieldOf("y_ascending", VariantContext.defaultRandomProperty(true)).forGetter(RandomizedProcessingStep::yAscending), (App)VariantContext.wrappedRandomCodec(Codec.BOOL).optionalFieldOf("z_ascending", VariantContext.defaultRandomProperty(true)).forGetter(RandomizedProcessingStep::zAscending)).apply((Applicative)instance, RandomizedProcessingStep::new));

        @Override
        public ProcessingStep sample(RandomSource random, VariantContext context) throws RandomProperty.NoRandomMatchException {
            HashMap<String, Parameter.Sampler> localParameters = new HashMap<String, Parameter.Sampler>();
            for (Map.Entry<String, RandomProperty<Parameter, VariantContext, VariantContext.Predicate>> entry : this.localParameters.entrySet()) {
                localParameters.put(entry.getKey(), entry.getValue().sample(random, context).createSampler(context.getVisitor()));
            }
            VariantContext localContext = context.withParameters(localParameters);
            ArrayList<Rule> rules = new ArrayList<Rule>();
            for (RandomProperty<Rule.RandomizedRule, VariantContext, VariantContext.Predicate> rule : this.rules) {
                try {
                    rules.add(Rule.sampleAll(rule.sample(random, context), random, context));
                }
                catch (RandomProperty.NoRandomMatchException noRandomMatchException) {}
            }
            Either<String, Parameter> mask = this.mask.sample(random, localContext);
            return new ProcessingStep((Parameter.Sampler)mask.map(parRef -> localContext.userParameters().get(parRef), par -> par.createSampler(localContext.getVisitor())), localParameters, this.xAscending.sample(random, context), this.yAscending.sample(random, context), this.zAscending.sample(random, context), rules);
        }
    }
}

