/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.utils.ChamferTransform;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public class BorderChamferDistance
implements class_6910.class_6913 {
    private static final MapCodec<BorderChamferDistance> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("normalize", (Object)true).forGetter(d -> d.normalize)).apply((Applicative)instance, BorderChamferDistance::new));
    public static final class_7243<BorderChamferDistance> CODEC_HOLDER = class_7243.method_42116(CODEC);
    public final boolean normalize;
    private double[][] dist = null;
    private boolean[][] isTarget = null;
    private int minX;
    private int minZ;
    private int maxX;
    private int maxZ;
    public double maxDist = 0.0;

    public BorderChamferDistance(boolean normalize) {
        this.normalize = normalize;
    }

    public BorderChamferDistance create(boolean[][] isTarget, int minX, int maxX, int minZ, int maxZ) {
        BorderChamferDistance copy = new BorderChamferDistance(this.normalize);
        copy.isTarget = isTarget;
        copy.minX = minX;
        copy.maxX = maxX;
        copy.minZ = minZ;
        copy.maxZ = maxZ;
        return copy;
    }

    public double method_40464(class_6910.class_6912 pos) {
        if (this.dist == null && this.isTarget != null) {
            this.dist = ChamferTransform.distanceTransform(this.isTarget);
            this.maxDist = 0.0;
            for (int x = 0; x < this.dist.length; ++x) {
                for (int z = 0; z < this.dist[0].length; ++z) {
                    double[] dArray = this.dist[x];
                    int n = z;
                    dArray[n] = dArray[n] / 2.0;
                    this.maxDist = Math.max(this.dist[x][z], this.maxDist);
                }
            }
        }
        if (this.dist == null) {
            return 0.0;
        }
        if (pos.comp_371() < this.minX || pos.comp_371() > this.maxX || pos.comp_373() < this.minZ || pos.comp_373() > this.maxZ) {
            return 0.0;
        }
        double val = this.dist[pos.comp_371() - this.minX][pos.comp_373() - this.minZ];
        return this.normalize ? val / this.maxDist : val;
    }

    public double comp_377() {
        return 0.0;
    }

    public double comp_378() {
        return this.normalize ? 1.0 : this.maxDist;
    }

    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }
}

