/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.LandmarksMod;
import io.github.orlouge.landmarks.features.FeatureDensityFunctionContext;
import io.github.orlouge.landmarks.generation.BlockTemplate;
import io.github.orlouge.landmarks.utils.MaxDensitySquare;
import io.github.orlouge.landmarks.utils.RandomProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3481;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6910;
import net.minecraft.class_7924;

public class SurfaceNoiseFeature
extends class_3031<Config> {
    public SurfaceNoiseFeature(Codec<Config> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<Config> context) {
        class_2338 origin;
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        class_2338 center = origin = context.method_33655();
        class_2680 originBlock = world.method_8320(origin.method_10069(0, -1, 0));
        class_6880 biome = context.method_33652().method_23753(origin);
        class_1923 originChunk = new class_1923(origin);
        long seed = random.method_43055();
        boolean debug = false;
        try {
            InstanceConfig config = ((Config)context.method_33656()).instances.sample(random, new VariantContext((class_6880<class_1959>)biome, Collections.emptySet(), originBlock));
            VariantContext variantContext = new VariantContext((class_6880<class_1959>)biome, new HashSet<String>(), originBlock);
            for (RandomProperty<String, VariantContext, VariantContext.Predicate> variant : config.variant) {
                try {
                    variantContext.variant.add(variant.sample(random, variantContext));
                }
                catch (RandomProperty.NoRandomMatchException noRandomMatchException) {}
            }
            if (variantContext.variant.contains("debug")) {
                debug = true;
                System.out.println("#################################");
                System.out.println("Variants: " + String.join((CharSequence)", ", variantContext.variant));
                System.out.println("Biome: " + variantContext.biome.method_55840());
                System.out.println("Origin: " + variantContext.origin.method_26204().method_40142().method_55840() + " at " + String.valueOf(origin));
            }
            if (variantContext.variant.contains("abort")) {
                return false;
            }
            int maxHeight = this.randomBetween(random, config.minHeight.sample(random, variantContext), config.maxHeight.sample(random, variantContext));
            maxHeight = Math.min(maxHeight, world.method_31600() - origin.method_10264());
            int maxDepth = this.randomBetween(random, config.minDepth.sample(random, variantContext), config.maxDepth.sample(random, variantContext));
            maxDepth = Math.min(maxDepth, origin.method_10264() - world.method_31607() + 1);
            int maxWidth = this.randomBetween(random, config.minWidth.sample(random, variantContext), config.maxWidth.sample(random, variantContext));
            int requiredFreeSpace = config.minSurface.sample(random, variantContext);
            class_6885<class_2248> freeSpaceAbove = config.usableSpaceAbove.sample(random, variantContext);
            class_6885<class_2248> freeSpaceBelow = config.usableSpaceBelow.sample(random, variantContext);
            Palette randomPalette = config.palette.sample(random, variantContext);
            Map<String, BlockTemplate> palette = randomPalette.sampleAll(random, variantContext);
            Optional allowedSurfaceCopy = randomPalette.allowedSurfaceCopy.isPresent() ? Optional.of(randomPalette.allowedSurfaceCopy.get().sample(random, variantContext)) : Optional.empty();
            boolean circularBorder = config.circularBorder.sample(random, variantContext);
            int scanWidth = config.searchAround ? 96 : maxWidth;
            int minZ = Math.max((originChunk.field_9180 - 1) * 16, center.method_10260() - scanWidth / 2);
            int maxZ = Math.min((originChunk.field_9180 + 1) * 16 - 1, center.method_10260() + scanWidth / 2);
            int minX = Math.max((originChunk.field_9181 - 1) * 16, center.method_10263() - scanWidth / 2);
            int maxX = Math.min((originChunk.field_9181 + 1) * 16 - 1, center.method_10263() + scanWidth / 2);
            int xExt = maxX - minX + 1;
            int zExt = maxZ - minZ + 1;
            int radius = Math.min(xExt, zExt) / 2;
            int sqRadius = radius * radius;
            int middleX = minX + xExt / 2;
            int middleZ = minZ + zExt / 2;
            boolean[][] cantPlace = new boolean[scanWidth + 3][scanWidth + 3];
            int freeSpace = 0;
            for (int x = 0; x < cantPlace.length; ++x) {
                for (int z = 0; z < cantPlace[0].length; ++z) {
                    cantPlace[x][z] = true;
                }
            }
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    class_2338 class_23382 = new class_2338(x, center.method_10264(), z);
                    if (!config.searchAround && circularBorder && (x - middleX) * (x - middleX) + (z - middleZ) * (z - middleZ) > sqRadius || !IntStream.range(0, maxHeight + 1).allMatch(off -> world.method_8320(pos.method_10069(0, off, 0)).method_40143(freeSpaceAbove)) || !IntStream.range(1, maxDepth + 1).allMatch(off -> world.method_8320(pos.method_10069(0, -off, 0)).method_40143(freeSpaceBelow))) continue;
                    cantPlace[x - minX + 1][z - minZ + 1] = false;
                    ++freeSpace;
                }
            }
            if (config.searchAround) {
                int originalMaxWidth = maxWidth;
                MaxDensitySquare.Result bestSquare = MaxDensitySquare.findDenseSquare(cantPlace, 100 * (1 + maxWidth), random, random2 -> this.randomBetween((class_5819)random2, (int)Math.sqrt(requiredFreeSpace), originalMaxWidth), result -> result.count() >= requiredFreeSpace ? (double)result.count() * Math.pow((double)result.count() / (double)(result.size() * result.size()), 5.0) : (double)(result.count() - requiredFreeSpace));
                maxWidth = Math.min(bestSquare.size(), maxWidth);
                middleX = minX + (bestSquare.x() - 1) + maxWidth / 2;
                middleZ = minZ + (bestSquare.y() - 1) + maxWidth / 2;
                int n = minX;
                int originalMinZ = minZ;
                minZ = Math.max((originChunk.field_9180 - 1) * 16, middleZ - maxWidth / 2);
                maxZ = Math.min((originChunk.field_9180 + 1) * 16 - 1, middleZ + maxWidth / 2);
                minX = Math.max((originChunk.field_9181 - 1) * 16, middleX - maxWidth / 2);
                maxX = Math.min((originChunk.field_9181 + 1) * 16 - 1, middleX + maxWidth / 2);
                xExt = maxX - minX + 1;
                zExt = maxZ - minZ + 1;
                radius = Math.min(xExt, zExt) / 2;
                sqRadius = radius * radius;
                middleX = minX + xExt / 2;
                middleZ = minZ + zExt / 2;
                if (debug) {
                    System.out.println("Free space before: " + freeSpace);
                    System.out.println("Offset: " + bestSquare.x() + ", " + bestSquare.y());
                }
                freeSpace = 0;
                boolean[][] cantPlace2 = new boolean[maxWidth + 3][maxWidth + 3];
                for (int x = 0; x < cantPlace2.length; ++x) {
                    for (int z = 0; z < cantPlace2[0].length; ++z) {
                        cantPlace2[x][z] = true;
                    }
                }
                for (int z = minZ; z <= maxZ; ++z) {
                    for (int x = minX; x <= maxX; ++x) {
                        if (circularBorder && (x - middleX) * (x - middleX) + (z - middleZ) * (z - middleZ) > sqRadius || cantPlace[x - n + 1][z - originalMinZ + 1]) continue;
                        cantPlace2[x - minX + 1][z - minZ + 1] = false;
                        ++freeSpace;
                    }
                }
                cantPlace = cantPlace2;
            }
            if (debug) {
                System.out.println();
                System.out.println("Width \u2264 " + maxWidth);
                System.out.println("Height \u2264 " + maxHeight);
                System.out.println("Depth \u2264 " + maxDepth);
                System.out.println("Free space = " + freeSpace + (freeSpace < requiredFreeSpace ? " (!)" : ""));
            }
            if (freeSpace < requiredFreeSpace) {
                return false;
            }
            HashMap<String, Double> userParameters = new HashMap<String, Double>();
            for (Map.Entry<String, RandomProperty<Double, VariantContext, VariantContext.Predicate>> entry : config.userParameters.sample(random, variantContext).entrySet()) {
                userParameters.put(entry.getKey(), entry.getValue().sample(random, variantContext));
            }
            if (debug) {
                System.out.println();
                for (Map.Entry<String, RandomProperty<Double, VariantContext, VariantContext.Predicate>> entry : userParameters.entrySet()) {
                    System.out.println(entry.getKey() + " = " + String.valueOf(entry.getValue()));
                }
            }
            int surfaceY = origin.method_10264() - 1;
            int n = Math.min(world.method_31600(), surfaceY + maxHeight);
            int minY = Math.max(world.method_31607(), surfaceY - maxDepth + 1);
            int yExt = n - minY + 1;
            FeatureDensityFunctionContext densityContext = new FeatureDensityFunctionContext(seed, minX, maxX, minY, n, minZ, maxZ, surfaceY, cantPlace, userParameters);
            HashMap<String, class_6910> densityFunctions = new HashMap<String, class_6910>();
            for (Map.Entry<String, RandomProperty<class_6910, VariantContext, VariantContext.Predicate>> entry : config.densityFunctions.sample(random, variantContext).entrySet()) {
                densityFunctions.put(entry.getKey(), entry.getValue().sample(random, variantContext).method_40469(densityContext.getVisitor()));
            }
            HashMap<String, double[]> densityValues = new HashMap<String, double[]>();
            for (Map.Entry entry : densityFunctions.entrySet()) {
                double[] values = new double[xExt * yExt * zExt];
                for (int z = minZ; z <= maxZ; ++z) {
                    for (int x = minX; x <= maxX; ++x) {
                        for (int y2 = minY; y2 <= n; ++y2) {
                            int idx = (xExt * (y2 - minY) + (x - minX)) * zExt + (z - minZ);
                            values[idx] = ((class_6910)entry.getValue()).method_40464((class_6910.class_6912)new class_6910.class_6914(x, y2, z));
                        }
                    }
                }
                densityValues.put((String)entry.getKey(), values);
            }
            if (debug) {
                System.out.println();
                for (Map.Entry entry : densityValues.entrySet()) {
                    double x;
                    int idx;
                    double min = Double.POSITIVE_INFINITY;
                    double max = Double.NEGATIVE_INFINITY;
                    double avg = 0.0;
                    double std = 0.0;
                    for (idx = 0; idx < ((double[])entry.getValue()).length; ++idx) {
                        x = ((double[])entry.getValue())[idx];
                        min = Math.min(min, x);
                        max = Math.max(max, x);
                        avg += x;
                    }
                    avg /= (double)((double[])entry.getValue()).length;
                    for (idx = 0; idx < ((double[])entry.getValue()).length; ++idx) {
                        x = ((double[])entry.getValue())[idx];
                        std += (x - avg) * (x - avg);
                    }
                    std = Math.sqrt(std / (double)((double[])entry.getValue()).length);
                    System.out.println((String)entry.getKey() + " \u2208 [" + min + ", " + max + "] (Mean: " + avg + " \u00b1 " + std + ")");
                }
            }
            ArrayList<SampledRuleSet> arrayList = new ArrayList<SampledRuleSet>();
            for (RuleSet ruleSet : config.processingSteps.sample(random, variantContext)) {
                arrayList.add(SampledRuleSet.sampleAll(ruleSet, random, variantContext, palette, densityValues, densityFunctions, userParameters));
            }
            for (SampledRuleSet ruleSet : arrayList) {
                IntStream ysStream;
                Optional<Integer> startY = ruleSet.startRelativeY().map(y -> Math.max(minY, Math.min(maxY, y + surfaceY)));
                Optional<Integer> endY = ruleSet.endRelativeY().map(y -> Math.max(minY, Math.min(maxY, y + surfaceY)));
                if (startY.isPresent() && endY.isPresent()) {
                    if (endY.get() >= startY.get()) {
                        ysStream = IntStream.range(startY.get(), endY.get() + 1);
                    } else {
                        ysStream = IntStream.range(endY.get(), startY.get() + 1);
                        ysStream = ysStream.map(i -> (Integer)startY.get() + (Integer)endY.get() - i);
                    }
                } else {
                    ysStream = endY.isPresent() ? IntStream.range(minY, endY.get() + 1) : (startY.isPresent() ? IntStream.range(startY.get(), n + 1) : IntStream.range(minY, n + 1));
                }
                int[] ys = ysStream.toArray();
                for (int z = minZ; z <= maxZ; ++z) {
                    for (int x = minX; x <= maxX; ++x) {
                        class_2680 ground = world.method_8320(new class_2338(x, surfaceY, z));
                        if (allowedSurfaceCopy.isEmpty() && ground.method_51367() && !ground.method_26164(class_3481.field_33757) || allowedSurfaceCopy.isPresent() && ((class_6885)allowedSurfaceCopy.get()).method_40241(ground.method_41520())) {
                            palette.put("%surface", BlockTemplate.block(ground));
                            palette.put("%surface_reset_state", BlockTemplate.block(ground.method_26204().method_9564()));
                        } else {
                            palette.put("%surface", BlockTemplate.empty());
                            palette.put("%surface_reset_state", BlockTemplate.empty());
                        }
                        block27: for (int y3 : ys) {
                            class_2338 pos = new class_2338(x, y3, z);
                            int idx = (xExt * (y3 - minY) + (x - minX)) * zExt + (z - minZ);
                            class_6910.class_6914 noisePos = new class_6910.class_6914(x, y3, z);
                            class_6880 blockBeingReplaced = world.method_8320(pos).method_41520();
                            block28: for (SampledRule rule : ruleSet.rules) {
                                class_2680 blockToPlace;
                                if (rule.impossible || rule.blockAbove.isPresent() && !rule.blockAbove.get().method_40241(world.method_8320(pos.method_10069(0, 1, 0)).method_41520()) || rule.blockBelow.isPresent() && !rule.blockBelow.get().method_40241(world.method_8320(pos.method_10069(0, -1, 0)).method_41520()) || rule.blockBeingReplaced.isPresent() && !rule.blockBeingReplaced.get().method_40241(blockBeingReplaced) || ((Boolean)rule.cantReplace.map(arg_0 -> ((class_6880)blockBeingReplaced).method_40220(arg_0), list -> list.method_40241(blockBeingReplaced))).booleanValue()) continue;
                                for (Condition condition : rule.densityConditions) {
                                    if (condition.test(idx, (class_6910.class_6912)noisePos)) continue;
                                    continue block28;
                                }
                                class_2680 class_26802 = blockToPlace = rule.template == null ? null : rule.template.getBlockState(world, random, palette);
                                if (blockToPlace != null) {
                                    if (rule.autoWaterlog && blockBeingReplaced.comp_349() == class_2246.field_10382 && blockToPlace.method_28498((class_2769)class_2741.field_12508)) {
                                        blockToPlace = (class_2680)blockToPlace.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
                                    }
                                    if (!rule.postPorcessing) {
                                        LandmarksMod.DISABLE_POST_PROCESSING_ONCE = true;
                                    }
                                    world.method_8652(pos, blockToPlace, 2);
                                    continue block27;
                                }
                                if (rule.passThroughIfNotReplaced) continue;
                            }
                        }
                    }
                }
            }
        }
        catch (RandomProperty.NoRandomMatchException e) {
            return false;
        }
        if (debug) {
            System.out.println("#################################\n\n");
        }
        return true;
    }

    public int randomBetween(class_5819 random, int min, int max) {
        return max > min ? random.method_39332(min, max) : min;
    }

    public static <T> Codec<RandomProperty<T, VariantContext, VariantContext.Predicate>> strictWrappedRandomCodec(Codec<T> entryCodec, String valueKey) {
        return RandomProperty.strictWrappedCodec(entryCodec, VariantContext.Predicate.CODEC, new VariantContext.Predicate(), valueKey);
    }

    public static <T> Codec<RandomProperty<T, VariantContext, VariantContext.Predicate>> strictWrappedRandomCodec(Codec<T> entryCodec) {
        return RandomProperty.strictWrappedCodec(entryCodec, VariantContext.Predicate.CODEC, new VariantContext.Predicate());
    }

    public static <T> Codec<RandomProperty<T, VariantContext, VariantContext.Predicate>> extendRandomCodec(MapCodec<T> entryCodec) {
        return RandomProperty.extendCodec(entryCodec, VariantContext.Predicate.CODEC, new VariantContext.Predicate());
    }

    public static <T> RandomProperty<T, VariantContext, VariantContext.Predicate> defaultRandomProperty(T value) {
        return RandomProperty.singleton(value, new VariantContext.Predicate());
    }

    public static <T> Codec<RandomProperty<T, VariantContext, VariantContext.Predicate>> wrappedRandomCodec(Codec<T> entryCodec, String valueKey) {
        return RandomProperty.wrappedCodec(entryCodec, VariantContext.Predicate.CODEC, new VariantContext.Predicate(), valueKey);
    }

    public static <T> Codec<RandomProperty<T, VariantContext, VariantContext.Predicate>> wrappedRandomCodec(Codec<T> entryCodec) {
        return RandomProperty.wrappedCodec(entryCodec, VariantContext.Predicate.CODEC, new VariantContext.Predicate());
    }

    public record Config(RandomProperty<InstanceConfig, VariantContext, VariantContext.Predicate> instances) implements class_3037
    {
        public static final Codec<Config> CODEC = SurfaceNoiseFeature.extendRandomCodec(InstanceConfig.CODEC).xmap(Config::new, Config::instances);
    }

    public record VariantContext(class_6880<class_1959> biome, Set<String> variant, class_2680 origin) {

        public record Predicate(Optional<class_6885<class_1959>> biomes, Optional<HashSet<String>> variantsAny, Optional<HashSet<String>> variantsAll, Optional<class_6885<class_2248>> originIs) implements RandomProperty.ContextPredicate<VariantContext>
        {
            public static final MapCodec<Predicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41236).optionalFieldOf("biome").forGetter(Predicate::biomes), (App)Codec.STRING.listOf().xmap(HashSet::new, set -> set.stream().toList()).optionalFieldOf("any_variant").forGetter(Predicate::variantsAny), (App)Codec.STRING.listOf().xmap(HashSet::new, set -> set.stream().toList()).optionalFieldOf("has_variants").forGetter(Predicate::variantsAll), (App)class_6895.method_40340((class_5321)class_7924.field_41254).optionalFieldOf("origin").forGetter(Predicate::originIs)).apply((Applicative)instance, Predicate::new));

            public Predicate() {
                this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            }

            @Override
            public boolean isDefault() {
                return this.biomes.isEmpty() && this.variantsAny.isEmpty() && this.variantsAll.isEmpty();
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean test(VariantContext context) {
                if (this.biomes.map(list -> list.method_40241(context.biome)).orElse(true) == false) return false;
                if (this.variantsAny.map(variantSet -> {
                    HashSet variantSetCopy = new HashSet(variantSet);
                    variantSetCopy.retainAll(context.variant);
                    return !variantSetCopy.isEmpty();
                }).orElse(true) == false) return false;
                if (this.variantsAll.map(context.variant::containsAll).orElse(true) == false) return false;
                if (this.originIs.map(o -> o.method_40241(context.origin.method_41520())).orElse(true) == false) return false;
                return true;
            }
        }
    }

    public record InstanceConfig(RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate> usableSpaceAbove, RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate> usableSpaceBelow, RandomProperty<Map<String, RandomProperty<class_6910, VariantContext, VariantContext.Predicate>>, VariantContext, VariantContext.Predicate> densityFunctions, RandomProperty<Map<String, RandomProperty<Double, VariantContext, VariantContext.Predicate>>, VariantContext, VariantContext.Predicate> userParameters, RandomProperty<List<RuleSet>, VariantContext, VariantContext.Predicate> processingSteps, RandomProperty<Integer, VariantContext, VariantContext.Predicate> minWidth, RandomProperty<Integer, VariantContext, VariantContext.Predicate> maxWidth, RandomProperty<Integer, VariantContext, VariantContext.Predicate> minHeight, RandomProperty<Integer, VariantContext, VariantContext.Predicate> maxHeight, RandomProperty<Integer, VariantContext, VariantContext.Predicate> minDepth, RandomProperty<Integer, VariantContext, VariantContext.Predicate> maxDepth, RandomProperty<Integer, VariantContext, VariantContext.Predicate> minSurface, boolean searchAround, RandomProperty<Palette, VariantContext, VariantContext.Predicate> palette, List<RandomProperty<String, VariantContext, VariantContext.Predicate>> variant, RandomProperty<Boolean, VariantContext, VariantContext.Predicate> circularBorder) {
        public static final MapCodec<InstanceConfig> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SurfaceNoiseFeature.strictWrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks").fieldOf("usable_space_above").forGetter(InstanceConfig::usableSpaceAbove), (App)SurfaceNoiseFeature.strictWrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks").fieldOf("usable_space_below").forGetter(InstanceConfig::usableSpaceBelow), (App)SurfaceNoiseFeature.strictWrappedRandomCodec(Codec.unboundedMap((Codec)Codec.STRING, SurfaceNoiseFeature.strictWrappedRandomCodec(class_6910.field_37059, "function"))).fieldOf("density_functions").forGetter(InstanceConfig::densityFunctions), (App)SurfaceNoiseFeature.wrappedRandomCodec(Codec.unboundedMap((Codec)Codec.STRING, SurfaceNoiseFeature.wrappedRandomCodec(Codec.DOUBLE)), "params").fieldOf("user_parameters").forGetter(InstanceConfig::userParameters), (App)SurfaceNoiseFeature.wrappedRandomCodec(RuleSet.CODEC.codec().listOf(), "steps").fieldOf("processing_sequence").forGetter(InstanceConfig::processingSteps), (App)SurfaceNoiseFeature.wrappedRandomCodec(Codec.intRange((int)1, (int)48)).fieldOf("min_width").forGetter(InstanceConfig::minWidth), (App)SurfaceNoiseFeature.wrappedRandomCodec(Codec.intRange((int)1, (int)48)).fieldOf("max_width").forGetter(InstanceConfig::maxWidth), (App)SurfaceNoiseFeature.wrappedRandomCodec(class_5699.field_33441).fieldOf("min_height").forGetter(InstanceConfig::minHeight), (App)SurfaceNoiseFeature.wrappedRandomCodec(class_5699.field_33441).fieldOf("max_height").forGetter(InstanceConfig::maxHeight), (App)SurfaceNoiseFeature.wrappedRandomCodec(class_5699.field_33441).fieldOf("min_depth").forGetter(InstanceConfig::minDepth), (App)SurfaceNoiseFeature.wrappedRandomCodec(class_5699.field_33441).fieldOf("max_depth").forGetter(InstanceConfig::maxDepth), (App)SurfaceNoiseFeature.wrappedRandomCodec(class_5699.field_33441).fieldOf("min_surface").forGetter(InstanceConfig::minSurface), (App)Codec.BOOL.optionalFieldOf("search_around", (Object)false).forGetter(InstanceConfig::searchAround), (App)SurfaceNoiseFeature.extendRandomCodec(Palette.CODEC).optionalFieldOf("palette", SurfaceNoiseFeature.defaultRandomProperty(new Palette())).forGetter(InstanceConfig::palette), (App)SurfaceNoiseFeature.wrappedRandomCodec(Codec.STRING, "name").listOf().optionalFieldOf("variants", List.of()).forGetter(InstanceConfig::variant), (App)SurfaceNoiseFeature.wrappedRandomCodec(Codec.BOOL).optionalFieldOf("circular_border", SurfaceNoiseFeature.defaultRandomProperty(false)).forGetter(InstanceConfig::circularBorder)).apply((Applicative)instance, InstanceConfig::new));
    }

    public record Palette(Map<String, RandomProperty<PalettedBlockTemplate, VariantContext, VariantContext.Predicate>> entries, Optional<RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate>> allowedSurfaceCopy) {
        public static final MapCodec<Palette> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, SurfaceNoiseFeature.wrappedRandomCodec(PalettedBlockTemplate.CODEC, "block")).fieldOf("entries").forGetter(Palette::entries), (App)SurfaceNoiseFeature.wrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks").optionalFieldOf("allowed_surface_copy").forGetter(Palette::allowedSurfaceCopy)).apply((Applicative)instance, Palette::new));

        public Palette() {
            this(new HashMap<String, RandomProperty<PalettedBlockTemplate, VariantContext, VariantContext.Predicate>>(), Optional.empty());
        }

        public Map<String, BlockTemplate> sampleAll(class_5819 random, VariantContext context) throws RandomProperty.NoRandomMatchException {
            HashMap<String, BlockTemplate> resolved = new HashMap<String, BlockTemplate>();
            HashMap<String, String> unresolved = new HashMap<String, String>();
            for (Map.Entry<String, RandomProperty<PalettedBlockTemplate, VariantContext, VariantContext.Predicate>> entry : this.entries.entrySet()) {
                try {
                    PalettedBlockTemplate sampled = entry.getValue().sample(random, context);
                    sampled.referenceOrTemplate.map(str -> str.startsWith("%") ? resolved.put((String)entry.getKey(), BlockTemplate.parse("%" + str)) : unresolved.put((String)entry.getKey(), (String)str), template -> resolved.put((String)entry.getKey(), (BlockTemplate)template));
                }
                catch (RandomProperty.NoRandomMatchException ignored) {
                    resolved.put(entry.getKey(), null);
                }
            }
            int lastUnresolvedCount = unresolved.size();
            int unchangedIterations = 0;
            while (!unresolved.isEmpty() && unchangedIterations < 10) {
                Iterator it = unresolved.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String reference = (String)entry.getValue();
                    if (resolved.containsKey(reference)) {
                        it.remove();
                        resolved.put((String)entry.getKey(), (BlockTemplate)resolved.get(reference));
                        continue;
                    }
                    if (unresolved.containsKey(reference)) {
                        unresolved.put((String)entry.getKey(), (String)unresolved.get(reference));
                        continue;
                    }
                    it.remove();
                    resolved.put((String)entry.getKey(), BlockTemplate.empty());
                    resolved.put(reference, BlockTemplate.empty());
                }
                if (unresolved.size() == lastUnresolvedCount) {
                    ++unchangedIterations;
                    continue;
                }
                unchangedIterations = 0;
                lastUnresolvedCount = unresolved.size();
            }
            if (!unresolved.isEmpty()) {
                throw new RuntimeException("Unresolved palette references: " + String.join((CharSequence)", ", unresolved.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).toList()) + " (variants: " + String.join((CharSequence)", ", context.variant) + ")");
            }
            return resolved;
        }
    }

    public record RuleSet(List<RandomProperty<Rule, VariantContext, VariantContext.Predicate>> rules, Optional<Integer> startRelativeY, Optional<Integer> endRelativeY) {
        public static final MapCodec<RuleSet> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SurfaceNoiseFeature.extendRandomCodec(Rule.CODEC).listOf().fieldOf("rules").forGetter(RuleSet::rules), (App)Codec.INT.optionalFieldOf("start_relative_y").forGetter(RuleSet::startRelativeY), (App)Codec.INT.optionalFieldOf("end_relative_y").forGetter(RuleSet::endRelativeY)).apply((Applicative)instance, RuleSet::new));
    }

    public record SampledRuleSet(List<SampledRule> rules, Optional<Integer> startRelativeY, Optional<Integer> endRelativeY) {
        public static SampledRuleSet sampleAll(RuleSet ruleSet, class_5819 random, VariantContext context, Map<String, BlockTemplate> palette, Map<String, double[]> densityValues, Map<String, class_6910> densityFunctions, Map<String, Double> userParameters) {
            ArrayList<SampledRule> rules = new ArrayList<SampledRule>();
            for (RandomProperty<Rule, VariantContext, VariantContext.Predicate> rule : ruleSet.rules) {
                try {
                    rules.add(SampledRule.sampleAll(rule.sample(random, context), random, context, palette, densityValues, densityFunctions, userParameters));
                }
                catch (RandomProperty.NoRandomMatchException noRandomMatchException) {}
            }
            return new SampledRuleSet(rules, ruleSet.startRelativeY, ruleSet.endRelativeY);
        }
    }

    public record SampledRule(BlockTemplate template, boolean postPorcessing, boolean autoWaterlog, boolean passThroughIfNotReplaced, boolean impossible, Optional<class_6885<class_2248>> blockBelow, Optional<class_6885<class_2248>> blockBeingReplaced, Optional<class_6885<class_2248>> blockAbove, Either<class_6862<class_2248>, class_6885<class_2248>> cantReplace, List<Condition> densityConditions) {
        public static SampledRule sampleAll(Rule rule, class_5819 random, VariantContext context, Map<String, BlockTemplate> palette, Map<String, double[]> densityValues, Map<String, class_6910> densityFunctions, Map<String, Double> userParameters) throws RandomProperty.NoRandomMatchException {
            Optional<class_6885<class_2248>> blockBelow = Optional.empty();
            Optional<class_6885<class_2248>> blockBeingReplaced = Optional.empty();
            Optional<class_6885<class_2248>> blockAbove = Optional.empty();
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            if (rule.blockBelow.isPresent()) {
                blockBelow = Optional.of(rule.blockBelow.get().sample(random, context));
            }
            if (rule.blockBeingReplaced.isPresent()) {
                blockBeingReplaced = Optional.of(rule.blockBeingReplaced.get().sample(random, context));
            }
            if (rule.blockAbove.isPresent()) {
                blockAbove = Optional.of(rule.blockAbove.get().sample(random, context));
            }
            Either cantReplace = rule.cantReplace.left().isPresent() ? Either.left((Object)((class_6862)rule.cantReplace.left().get())) : Either.right((Object)((class_6885)((RandomProperty)rule.cantReplace().right().get()).sample(random, context)));
            for (RandomProperty<String, VariantContext, VariantContext.Predicate> condition : rule.densityConditions.sample(random, context)) {
                conditions.add(Condition.parse(condition.sample(random, context), userParameters, densityValues, densityFunctions));
            }
            BlockTemplate template = null;
            try {
                template = (BlockTemplate)rule.template.sample((class_5819)random, (VariantContext)context).referenceOrTemplate.map(palette::get, t -> t);
            }
            catch (RandomProperty.NoRandomMatchException noRandomMatchException) {
                // empty catch block
            }
            return new SampledRule(template == null ? null : template.copy(), rule.postProcessing, rule.autoWaterlog, rule.passThroughIfNotReplaced, rule.impossible, blockBelow, blockBeingReplaced, blockAbove, (Either<class_6862<class_2248>, class_6885<class_2248>>)cantReplace, conditions);
        }
    }

    public record Condition(List<Operand> operands, List<Operator> operators) {
        public static Condition parse(String condition, Map<String, Double> constants, Map<String, double[]> arrays, Map<String, class_6910> functions) {
            String[] split = condition.replaceAll(" +", "").splitWithDelimiters("([><!=]=?|[-+])", 0);
            ArrayList<Operand> operands = new ArrayList<Operand>();
            for (int i = 0; i < split.length; i += 2) {
                String variable = split[i];
                if (variable.isEmpty()) {
                    operands.add(new Constant(0.0));
                    continue;
                }
                if (arrays.containsKey(variable)) {
                    operands.add(new ConstantArray(arrays.get(variable)));
                    continue;
                }
                if (functions.containsKey(variable)) {
                    operands.add(new Density(functions.get(variable)));
                    continue;
                }
                if (constants.containsKey(variable)) {
                    operands.add(new Constant(constants.get(variable)));
                    continue;
                }
                if (Character.isDigit(variable.charAt(0))) {
                    operands.add(new Constant(Double.parseDouble(variable)));
                    continue;
                }
                throw new RuntimeException("Invalid condition operand: " + variable);
            }
            ArrayList<Operator> operators = new ArrayList<Operator>();
            for (int i = 1; i < split.length; i += 2) {
                String operator;
                operators.add(switch (operator = split[i]) {
                    case "==" -> Operator.EQ;
                    case "!=" -> Operator.NE;
                    case ">" -> Operator.GT;
                    case ">=" -> Operator.GE;
                    case "<" -> Operator.LT;
                    case "<=" -> Operator.LE;
                    case "+" -> Operator.ADD;
                    case "-" -> Operator.SUB;
                    case "*" -> Operator.MUL;
                    case "/" -> Operator.DIV;
                    default -> throw new IllegalStateException("Unexpected input: " + operator);
                });
            }
            return new Condition(operands, operators);
        }

        public boolean test(int idx, class_6910.class_6912 pos) {
            block22: {
                if (this.operands.size() <= 1) break block22;
                ArrayList<Double> conditionOperands = new ArrayList<Double>();
                ArrayList<Operator> conditionOperators = new ArrayList<Operator>();
                double accValue = this.operands.getFirst().get(idx, pos);
                int operatorIdx = 0;
                for (int i = 1; i < this.operands.size(); ++i) {
                    double value = this.operands.get(i).get(idx, pos);
                    Operator operator = this.operators.get(operatorIdx);
                    switch (operator.ordinal()) {
                        case 6: {
                            accValue += value;
                            break;
                        }
                        case 7: {
                            accValue -= value;
                            break;
                        }
                        case 8: {
                            accValue *= value;
                            break;
                        }
                        case 9: {
                            accValue /= value;
                            break;
                        }
                        default: {
                            conditionOperands.add(accValue);
                            conditionOperators.add(operator);
                            accValue = value;
                        }
                    }
                    ++operatorIdx;
                }
                conditionOperands.add(accValue);
                double lastValue = (Double)conditionOperands.getFirst();
                operatorIdx = 0;
                for (int i = 1; i < conditionOperands.size(); ++i) {
                    double value;
                    block23: {
                        value = (Double)conditionOperands.get(i);
                        Operator operator = (Operator)((Object)conditionOperators.get(operatorIdx));
                        switch (operator.ordinal()) {
                            case 0: {
                                if (lastValue <= value) {
                                    break;
                                }
                                break block23;
                            }
                            case 1: {
                                if (lastValue < value) {
                                    break;
                                }
                                break block23;
                            }
                            case 2: {
                                if (lastValue >= value) {
                                    break;
                                }
                                break block23;
                            }
                            case 3: {
                                if (lastValue > value) {
                                    break;
                                }
                                break block23;
                            }
                            case 4: {
                                if (lastValue != value) {
                                    break;
                                }
                                break block23;
                            }
                            case 5: {
                                if (lastValue == value) {
                                    break;
                                }
                                break block23;
                            }
                            default: {
                                break block23;
                            }
                        }
                        return false;
                    }
                    ++operatorIdx;
                    lastValue = value;
                }
            }
            return true;
        }

        private static class Constant
        implements Operand {
            private final double value;

            private Constant(double value) {
                this.value = value;
            }

            @Override
            public double get(int idx, class_6910.class_6912 pos) {
                return this.value;
            }
        }

        private static class ConstantArray
        implements Operand {
            private final double[] value;

            private ConstantArray(double[] value) {
                this.value = value;
            }

            @Override
            public double get(int idx, class_6910.class_6912 pos) {
                return this.value[idx];
            }
        }

        private static class Density
        implements Operand {
            private final class_6910 function;

            private Density(class_6910 function) {
                this.function = function;
            }

            @Override
            public double get(int idx, class_6910.class_6912 pos) {
                return this.function.method_40464(pos);
            }
        }

        public static enum Operator {
            GT,
            GE,
            LT,
            LE,
            EQ,
            NE,
            ADD,
            SUB,
            MUL,
            DIV;

        }

        public static interface Operand {
            public double get(int var1, class_6910.class_6912 var2);
        }
    }

    public record Rule(RandomProperty<PalettedBlockTemplate, VariantContext, VariantContext.Predicate> template, boolean postProcessing, boolean autoWaterlog, boolean passThroughIfNotReplaced, boolean impossible, Optional<RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate>> blockBelow, Optional<RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate>> blockBeingReplaced, Optional<RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate>> blockAbove, Either<class_6862<class_2248>, RandomProperty<class_6885<class_2248>, VariantContext, VariantContext.Predicate>> cantReplace, RandomProperty<List<RandomProperty<String, VariantContext, VariantContext.Predicate>>, VariantContext, VariantContext.Predicate> densityConditions) {
        public static final MapCodec<Rule> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SurfaceNoiseFeature.wrappedRandomCodec(PalettedBlockTemplate.CODEC, "block").optionalFieldOf("place", SurfaceNoiseFeature.defaultRandomProperty(new PalettedBlockTemplate((Either<String, BlockTemplate>)Either.right((Object)BlockTemplate.empty())))).forGetter(Rule::template), (App)Codec.BOOL.optionalFieldOf("post_processing", (Object)true).forGetter(Rule::postProcessing), (App)Codec.BOOL.optionalFieldOf("auto_waterlog", (Object)false).forGetter(Rule::autoWaterlog), (App)Codec.BOOL.optionalFieldOf("pass_through_if_not_replaced", (Object)false).forGetter(Rule::passThroughIfNotReplaced), (App)Codec.BOOL.optionalFieldOf("impossible", (Object)false).forGetter(Rule::impossible), (App)SurfaceNoiseFeature.strictWrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks").optionalFieldOf("block_below_is").forGetter(Rule::blockBelow), (App)SurfaceNoiseFeature.strictWrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks").optionalFieldOf("block_is").forGetter(Rule::blockBeingReplaced), (App)SurfaceNoiseFeature.strictWrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks").optionalFieldOf("block_above_is").forGetter(Rule::blockAbove), (App)Codec.either((Codec)class_6862.method_40093((class_5321)class_7924.field_41254), SurfaceNoiseFeature.strictWrappedRandomCodec(class_6895.method_40340((class_5321)class_7924.field_41254), "blocks")).optionalFieldOf("cant_replace", (Object)Either.left((Object)class_3481.field_33757)).forGetter(Rule::cantReplace), (App)SurfaceNoiseFeature.strictWrappedRandomCodec(SurfaceNoiseFeature.strictWrappedRandomCodec(Codec.STRING).listOf(), "conditions").optionalFieldOf("density_conditions", SurfaceNoiseFeature.defaultRandomProperty(List.of())).forGetter(Rule::densityConditions)).apply((Applicative)instance, Rule::new));
    }

    public record PalettedBlockTemplate(Either<String, BlockTemplate> referenceOrTemplate) {
        public static final Codec<PalettedBlockTemplate> CODEC = Codec.either((Codec)Codec.STRING.comapFlatMap(str -> str.startsWith("%") && !str.contains(";") && !str.contains("*") ? DataResult.success((Object)str.substring(1)) : DataResult.error(() -> "Palette references must begin with %."), ref -> "%" + ref), BlockTemplate.CODEC).xmap(PalettedBlockTemplate::new, PalettedBlockTemplate::referenceOrTemplate);
    }
}

