/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.utils;

import java.util.function.Function;
import net.minecraft.class_5819;

public class MaxDensitySquare {
    public static Result findDenseSquare(boolean[][] zero, int iterations, class_5819 rnd, Function<class_5819, Integer> side, Function<Result, Double> scoreFun) {
        int n = zero.length;
        int m = zero[0].length;
        int[][] prefixSum = new int[n + 1][m + 1];
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                prefixSum[i][j] = (zero[i - 1][j - 1] ? 0 : 1) + prefixSum[i - 1][j] + prefixSum[i][j - 1] - prefixSum[i - 1][j - 1];
            }
        }
        Result bestResult = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        for (int t = 0; t < iterations; ++t) {
            int sum;
            int y;
            int k = Math.min(Math.min(n, m), Math.max(1, side.apply(rnd)));
            int x = rnd.method_43048(n - k + 1);
            Result result = new Result(x, y = rnd.method_43048(m - k + 1), k, sum = MaxDensitySquare.squareSum(prefixSum, x, y, k));
            double score = scoreFun.apply(result);
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestResult = result;
        }
        return bestResult;
    }

    private static int squareSum(int[][] ps, int x, int y, int k) {
        int x2 = x + k;
        int y2 = y + k;
        return ps[x2][y2] - ps[x][y2] - ps[x2][y] + ps[x][y];
    }

    public record Result(int x, int y, int size, int count) {
    }
}

