/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.utils.WeightedRandomList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;

public record OldBiomeRandomProperty<T>(List<WrappedEntry<T>> entries) {
    public SamplerCreator<T> withReplacement(class_6880<class_1959> biome, boolean forced) throws NoBiomeMatchException {
        List<WrappedEntry> validEntries = this.entries.stream().filter(entry -> entry.biomes.isEmpty() || entry.biomes.get().method_40241(biome)).toList();
        if (validEntries.isEmpty()) {
            if (forced) {
                System.out.println("Ignoring biome constraints because there's no match.");
                validEntries = this.entries;
            } else {
                throw new NoBiomeMatchException();
            }
        }
        List<WrappedEntry> sampledEntries = validEntries;
        if (validEntries.size() == 1) {
            return random -> () -> ((WrappedEntry)sampledEntries.getFirst()).value;
        }
        return random -> {
            WeightedRandomList sampler = new WeightedRandomList();
            for (WrappedEntry entry : sampledEntries) {
                sampler.add(entry.weight, entry.value);
            }
            return () -> sampler.popSample(random);
        };
    }

    public Sampler<T> sampler(class_5819 random, class_6880<class_1959> biome, boolean forced) throws NoBiomeMatchException {
        WeightedRandomList sampler = new WeightedRandomList();
        for (WrappedEntry<T> entry : this.entries) {
            if (!entry.biomes.isEmpty() && !entry.biomes.get().method_40241(biome)) continue;
            sampler.add(entry.weight, entry.value);
        }
        if (sampler.size() == 0) {
            if (forced) {
                System.out.println("Ignoring biome constraints because there's no match.");
                for (WrappedEntry<T> entry : this.entries) {
                    sampler.add(entry.weight, entry.value);
                }
            } else {
                throw new NoBiomeMatchException();
            }
        }
        if (sampler.size() == 1) {
            Object entry = sampler.iterator().next();
            return () -> entry;
        }
        return () -> sampler.sample(random);
    }

    public static <U> OldBiomeRandomProperty<U> singleton(U entry) {
        return new OldBiomeRandomProperty(List.of(new WrappedEntry<U>(entry)));
    }

    public T sample(class_5819 random, class_6880<class_1959> biome) throws NoBiomeMatchException {
        return this.sampler(random, biome, false).sample();
    }

    public static <U extends Entry> Codec<OldBiomeRandomProperty<U>> flatCodec(Codec<U> entryCodec) {
        return Codec.either((Codec)entryCodec.listOf(1, Integer.MAX_VALUE), entryCodec).xmap(either -> (OldBiomeRandomProperty)either.map(entries -> new OldBiomeRandomProperty(entries.stream().map(entry -> new WrappedEntry<Entry>((Entry)entry, entry.getWeight(), entry.getBiomes())).toList()), entry -> new OldBiomeRandomProperty(List.of(new WrappedEntry<Entry>((Entry)entry, 1.0, Optional.empty())))), prop -> prop.entries.size() == 1 ? Either.right((Object)((Entry)prop.entries.getFirst().value)) : Either.left(prop.entries.stream().map(WrappedEntry::value).toList()));
    }

    public static <U> Codec<OldBiomeRandomProperty<U>> wrappedCodec(Codec<U> entryCodec, String valueKey) {
        return OldBiomeRandomProperty.flatCodec(WrappedEntry.codec(entryCodec, valueKey)).xmap(wrapped -> new OldBiomeRandomProperty(wrapped.entries.stream().map(WrappedEntry::value).toList()), unwrapped -> new OldBiomeRandomProperty(unwrapped.entries.stream().map(WrappedEntry::wrap).toList()));
    }

    public static <U> Codec<OldBiomeRandomProperty<U>> wrappedCodec(Codec<U> entryCodec) {
        return OldBiomeRandomProperty.wrappedCodec(entryCodec, "input");
    }

    public static <U> Codec<OldBiomeRandomProperty<U>> extendCodec(MapCodec<U> entryCodec) {
        return OldBiomeRandomProperty.flatCodec(WrappedEntry.extendCodec(entryCodec)).xmap(wrapped -> new OldBiomeRandomProperty(wrapped.entries.stream().map(WrappedEntry::value).toList()), unwrapped -> new OldBiomeRandomProperty(unwrapped.entries.stream().map(WrappedEntry::wrap).toList()));
    }

    public static class NoBiomeMatchException
    extends Exception {
        public NoBiomeMatchException() {
        }

        public NoBiomeMatchException(String message) {
            super(message);
        }
    }

    public static interface SamplerCreator<T> {
        public Sampler<T> sampler(class_5819 var1);
    }

    public record WrappedEntry<T>(T value, double weight, Optional<class_6885<class_1959>> biomes) implements Entry
    {
        public WrappedEntry(T value) {
            this(value, 1.0, Optional.empty());
        }

        public static <U> Codec<WrappedEntry<U>> codec(Codec<U> entryCodec, String valueKey) {
            Codec eitherCodec = Codec.either((Codec)RecordCodecBuilder.create(instance -> instance.group((App)entryCodec.fieldOf(valueKey).forGetter(WrappedEntry::value), (App)Codec.DOUBLE.optionalFieldOf("weight", (Object)1.0).forGetter(WrappedEntry::weight), (App)class_6895.method_40340((class_5321)class_7924.field_41236).optionalFieldOf("contextPredicate").forGetter(WrappedEntry::biomes)).apply((Applicative)instance, WrappedEntry::new)), entryCodec);
            return eitherCodec.xmap(either -> (WrappedEntry)either.map(e -> e, WrappedEntry::new), wrapped -> wrapped.weight == 1.0 && wrapped.biomes.isEmpty() ? Either.right(wrapped.value) : Either.left((Object)wrapped));
        }

        public static <U> Codec<WrappedEntry<U>> extendCodec(MapCodec<U> entryCodec) {
            Codec eitherCodec = Codec.either((Codec)RecordCodecBuilder.create(instance -> instance.group((App)entryCodec.forGetter(WrappedEntry::value), (App)Codec.DOUBLE.optionalFieldOf("weight", (Object)1.0).forGetter(WrappedEntry::weight), (App)class_6895.method_40340((class_5321)class_7924.field_41236).optionalFieldOf("contextPredicate").forGetter(WrappedEntry::biomes)).apply((Applicative)instance, WrappedEntry::new)), (Codec)entryCodec.codec());
            return eitherCodec.xmap(either -> (WrappedEntry)either.map(e -> e, WrappedEntry::new), wrapped -> wrapped.weight == 1.0 && wrapped.biomes.isEmpty() ? Either.right(wrapped.value) : Either.left((Object)wrapped));
        }

        public static <U> WrappedEntry<WrappedEntry<U>> wrap(WrappedEntry<U> entry) {
            return new WrappedEntry<WrappedEntry<U>>(entry, entry.weight, entry.biomes);
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        @Override
        public Optional<class_6885<class_1959>> getBiomes() {
            return this.biomes;
        }
    }

    public static interface Sampler<T> {
        public T sample();
    }

    public static interface Entry {
        public double getWeight();

        public Optional<class_6885<class_1959>> getBiomes();
    }
}

