/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.features.Parameter;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class FeatureUserParameter
implements DensityFunction.SimpleFunction {
    public static final MapCodec<FeatureUserParameter> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("parameter").forGetter(d -> d.parameter)).apply((Applicative)instance, FeatureUserParameter::new));
    public static final KeyDispatchDataCodec<FeatureUserParameter> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);
    private Parameter.Sampler sampler = null;
    private double min = 0.0;
    private double max = 0.0;
    public final String parameter;

    public FeatureUserParameter(String parameter) {
        this.parameter = parameter;
    }

    public FeatureUserParameter create(Parameter.Sampler par) {
        FeatureUserParameter copy = new FeatureUserParameter(this.parameter);
        copy.sampler = par;
        copy.min = par.min();
        copy.max = par.max();
        return copy;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        if (this.sampler == null) {
            throw new RuntimeException("Attempted to read unset user parameter: " + this.parameter);
        }
        return this.sampler.sample(pos);
    }

    public double minValue() {
        return this.min;
    }

    public double maxValue() {
        return this.max;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

