/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.operations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record MaxAlongY(DensityFunction argument, DensityFunction minY, DensityFunction maxY) implements DensityFunction
{
    public static final MapCodec<MaxAlongY> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(MaxAlongY::argument), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("min_y").forGetter(MaxAlongY::minY), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("max_y").forGetter(MaxAlongY::maxY)).apply((Applicative)instance, MaxAlongY::new));
    public static final KeyDispatchDataCodec<MaxAlongY> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    public double compute(DensityFunction.FunctionContext pos) {
        double max = Double.NEGATIVE_INFINITY;
        for (int y = (int)this.minY.compute(pos); y <= (int)this.maxY.compute(pos); ++y) {
            max = Math.max(max, this.argument.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.blockX(), y, pos.blockZ())));
        }
        return max;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new MaxAlongY(this.argument.mapAll(visitor), this.minY.mapAll(visitor), this.maxY.mapAll(visitor)));
    }

    public double minValue() {
        return Double.NEGATIVE_INFINITY;
    }

    public double maxValue() {
        return this.argument.maxValue();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

