/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.github.orlouge.landmarks.density.BoundedFunction;
import io.github.orlouge.landmarks.density.feature.FeatureUserParameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public abstract class Parameter {
    public static final Codec<Parameter> CODEC = Codec.either((Codec)Codec.DOUBLE, (Codec)DensityFunction.HOLDER_HELPER_CODEC).xmap(either -> (Parameter)either.map(Constant::new, Density::new), par -> {
        Either either;
        if (par instanceof Constant) {
            Constant cons = (Constant)par;
            either = Either.left((Object)cons.value);
        } else {
            either = Either.right((Object)((Density)par).function);
        }
        return either;
    });
    public static final Codec<Either<String, Parameter>> CODEC_NAMED = Codec.either((Codec)Codec.STRING.flatXmap(s -> s.contains(":") ? DataResult.error(() -> "Parameter names cannot contain ':'") : DataResult.success((Object)s), DataResult::success), CODEC);

    public abstract Sampler createSampler(DensityFunction.Visitor var1);

    public abstract Collection<String> referencedParameters();

    public static class Constant
    extends Parameter {
        public final double value;

        public Constant(double value) {
            this.value = value;
        }

        @Override
        public Sampler createSampler(DensityFunction.Visitor visitor) {
            return new Sampler(){

                @Override
                public double sample(DensityFunction.FunctionContext pos) {
                    return value;
                }

                @Override
                public Optional<BoundedFunction> bounds() {
                    return Optional.empty();
                }

                @Override
                public double min() {
                    return value;
                }

                @Override
                public double max() {
                    return value;
                }
            };
        }

        @Override
        public Collection<String> referencedParameters() {
            return List.of();
        }
    }

    public static class Density
    extends Parameter {
        public final DensityFunction function;

        public Density(DensityFunction function) {
            this.function = function;
        }

        @Override
        public Sampler createSampler(DensityFunction.Visitor visitor) {
            final DensityFunction visitedFunction = this.function.mapAll(visitor);
            return new Sampler(){

                @Override
                public double sample(DensityFunction.FunctionContext pos) {
                    return visitedFunction.compute(pos);
                }

                @Override
                public Optional<BoundedFunction> bounds() {
                    Optional<BoundedFunction> optional;
                    if (visitedFunction instanceof BoundedFunction) {
                        BoundedFunction bounded = (BoundedFunction)visitedFunction;
                        optional = Optional.of(bounded);
                    } else {
                        optional = Optional.empty();
                    }
                    return optional;
                }

                @Override
                public double min() {
                    return visitedFunction.minValue();
                }

                @Override
                public double max() {
                    return visitedFunction.maxValue();
                }
            };
        }

        @Override
        public Collection<String> referencedParameters() {
            HashSet<String> deps = new HashSet<String>();
            this.function.mapAll(fun -> {
                DensityFunctions.HolderHolder reg;
                Object patt0$temp;
                if (fun instanceof FeatureUserParameter) {
                    FeatureUserParameter par = (FeatureUserParameter)fun;
                    deps.add(par.parameter);
                }
                if (fun instanceof DensityFunctions.HolderHolder && (patt0$temp = (reg = (DensityFunctions.HolderHolder)fun).function().value()) instanceof FeatureUserParameter) {
                    FeatureUserParameter par = (FeatureUserParameter)patt0$temp;
                    deps.add(par.parameter);
                }
                return fun;
            });
            return deps;
        }
    }

    public record Condition(List<Sampler> operands, List<Operator> operators) {
        public static Condition parse(String condition, Map<String, Sampler> sampler) {
            String[] split = condition.replaceAll(" +", "").splitWithDelimiters("([><!=]=?|[-+])", 0);
            ArrayList<Sampler> operands = new ArrayList<Sampler>();
            for (int i = 0; i < split.length; i += 2) {
                String variable = split[i];
                if (variable.isEmpty()) {
                    operands.add(new Constant(0.0).createSampler(f -> f));
                    continue;
                }
                if (sampler.containsKey(variable)) {
                    operands.add(sampler.get(variable));
                    continue;
                }
                if (Character.isDigit(variable.charAt(0))) {
                    operands.add(new Constant(Double.parseDouble(variable)).createSampler(f -> f));
                    continue;
                }
                throw new RuntimeException("Invalid condition operand: " + variable);
            }
            ArrayList<Operator> operators = new ArrayList<Operator>();
            for (int i = 1; i < split.length; i += 2) {
                String operator;
                operators.add(switch (operator = split[i]) {
                    case "==" -> Operator.EQ;
                    case "!=" -> Operator.NE;
                    case ">" -> Operator.GT;
                    case ">=" -> Operator.GE;
                    case "<" -> Operator.LT;
                    case "<=" -> Operator.LE;
                    case "+" -> Operator.ADD;
                    case "-" -> Operator.SUB;
                    case "*" -> Operator.MUL;
                    case "/" -> Operator.DIV;
                    default -> throw new IllegalStateException("Unexpected input: " + operator);
                });
            }
            return new Condition(operands, operators);
        }

        public boolean test(DensityFunction.FunctionContext pos) {
            block22: {
                if (this.operands.size() <= 1) break block22;
                ArrayList<Double> conditionOperands = new ArrayList<Double>();
                ArrayList<Operator> conditionOperators = new ArrayList<Operator>();
                double accValue = this.operands.getFirst().sample(pos);
                int operatorIdx = 0;
                for (int i = 1; i < this.operands.size(); ++i) {
                    double value = this.operands.get(i).sample(pos);
                    Operator operator = this.operators.get(operatorIdx);
                    switch (operator.ordinal()) {
                        case 6: {
                            accValue += value;
                            break;
                        }
                        case 7: {
                            accValue -= value;
                            break;
                        }
                        case 8: {
                            accValue *= value;
                            break;
                        }
                        case 9: {
                            accValue /= value;
                            break;
                        }
                        default: {
                            conditionOperands.add(accValue);
                            conditionOperators.add(operator);
                            accValue = value;
                        }
                    }
                    ++operatorIdx;
                }
                conditionOperands.add(accValue);
                double lastValue = (Double)conditionOperands.getFirst();
                operatorIdx = 0;
                for (int i = 1; i < conditionOperands.size(); ++i) {
                    double value;
                    block23: {
                        value = (Double)conditionOperands.get(i);
                        Operator operator = (Operator)((Object)conditionOperators.get(operatorIdx));
                        switch (operator.ordinal()) {
                            case 0: {
                                if (lastValue <= value) {
                                    break;
                                }
                                break block23;
                            }
                            case 1: {
                                if (lastValue < value) {
                                    break;
                                }
                                break block23;
                            }
                            case 2: {
                                if (lastValue >= value) {
                                    break;
                                }
                                break block23;
                            }
                            case 3: {
                                if (lastValue > value) {
                                    break;
                                }
                                break block23;
                            }
                            case 4: {
                                if (lastValue != value) {
                                    break;
                                }
                                break block23;
                            }
                            case 5: {
                                if (lastValue == value) {
                                    break;
                                }
                                break block23;
                            }
                            default: {
                                break block23;
                            }
                        }
                        return false;
                    }
                    ++operatorIdx;
                    lastValue = value;
                }
            }
            return true;
        }

        public static enum Operator {
            GT,
            GE,
            LT,
            LE,
            EQ,
            NE,
            ADD,
            SUB,
            MUL,
            DIV;

        }
    }

    public static interface Sampler {
        public double sample(DensityFunction.FunctionContext var1);

        public Optional<BoundedFunction> bounds();

        public double min();

        public double max();
    }
}

