/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.algorithms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.BoundedFunction;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import java.util.Optional;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class GaussianBlur
implements DensityFunction,
FunctionWithCache.Simple {
    private static final MapCodec<GaussianBlur> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("kernel_radius", (Object)3).forGetter(d -> d.kernelRadius), (App)Codec.DOUBLE.optionalFieldOf("sigma", (Object)2.0).forGetter(d -> d.sigma), (App)Codec.BOOL.optionalFieldOf("normalize", (Object)true).forGetter(d -> d.normalize), (App)Codec.STRING.optionalFieldOf("key", (Object)"").forGetter(d -> d.key), (App)DensityFunction.f_208218_.fieldOf("argument").forGetter(d -> d.argument), (App)DensityFunction.f_208218_.fieldOf("min_x").forGetter(d -> d.minX), (App)DensityFunction.f_208218_.fieldOf("min_z").forGetter(d -> d.minZ), (App)DensityFunction.f_208218_.fieldOf("max_x").forGetter(d -> d.maxX), (App)DensityFunction.f_208218_.fieldOf("max_z").forGetter(d -> d.maxZ), (App)DensityFunction.f_208218_.optionalFieldOf("y").forGetter(d -> d.y)).apply((Applicative)instance, GaussianBlur::new));
    public static final KeyDispatchDataCodec<GaussianBlur> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_(CODEC);
    public final int kernelRadius;
    public final double sigma;
    public final boolean normalize;
    public final String key;
    public final DensityFunction argument;
    public final DensityFunction minX;
    public final DensityFunction minZ;
    public final DensityFunction maxX;
    public final DensityFunction maxZ;
    public final Optional<DensityFunction> y;
    private final Cache cache;

    private GaussianBlur(int kernelRadius, double sigma, boolean normalize, String key, DensityFunction argument, DensityFunction minX, DensityFunction minZ, DensityFunction maxX, DensityFunction maxZ, Optional<DensityFunction> y, Cache cache) {
        this.kernelRadius = kernelRadius;
        this.sigma = sigma;
        this.normalize = normalize;
        this.key = key;
        this.argument = argument;
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.y = y;
        this.cache = cache;
    }

    public GaussianBlur(int kernelRadius, double sigma, boolean normalize, String key, DensityFunction argument, DensityFunction minX, DensityFunction minZ, DensityFunction maxX, DensityFunction maxZ, Optional<DensityFunction> y) {
        this.kernelRadius = kernelRadius;
        this.sigma = sigma;
        this.normalize = normalize;
        this.key = key.isEmpty() ? null : key;
        this.argument = argument;
        this.minX = minX;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxZ = maxZ;
        this.y = y;
        this.cache = null;
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        if (pos.m_207115_() < this.cache.minX || pos.m_207115_() > this.cache.maxX || pos.m_207113_() < this.cache.minZ || pos.m_207113_() > this.cache.maxZ) {
            return 0.0;
        }
        double val = this.cache.blur[pos.m_207115_() - this.cache.minX][pos.m_207113_() - this.cache.minZ];
        return this.normalize ? (val - this.cache.minValue) / (this.cache.maxValue - this.cache.minValue) : val;
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new GaussianBlur(this.kernelRadius, this.sigma, this.normalize, this.key, this.argument.m_207456_(visitor), this.minX.m_207456_(visitor), this.minZ.m_207456_(visitor), this.maxX.m_207456_(visitor), this.maxZ.m_207456_(visitor), this.y, this.cache));
    }

    public double m_207402_() {
        return this.normalize || this.cache == null ? 0.0 : this.cache.minValue;
    }

    public double m_207401_() {
        return this.normalize || this.cache == null ? 1.0 : this.cache.maxValue;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC_HOLDER;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object createCache(int _minX, int _maxX, int _minY, int _maxY, int _minZ, int _maxZ) {
        int y = (int)this.y.map(d -> d.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0))).orElse(0.0).doubleValue();
        int minX = (int)this.minX.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, y, 0));
        int maxX = (int)this.maxX.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, y, 0));
        int minZ = (int)this.minZ.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, y, 0));
        int maxZ = (int)this.maxZ.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, y, 0));
        int extX = maxX - minX + 1;
        int extZ = maxZ - minZ + 1;
        double[][] value = new double[extX][extZ];
        boolean[][] isZero = new boolean[extX][extZ];
        DensityFunction densityFunction = this.argument;
        if (densityFunction instanceof BoundedFunction) {
            BoundedFunction maskBounds = (BoundedFunction)densityFunction;
            minZ = Math.max(minZ, maskBounds.minZ());
            maxZ = Math.min(maxZ, maskBounds.maxZ());
            minX = Math.max(minX, maskBounds.minX());
            maxX = Math.min(maxX, maskBounds.maxX());
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                value[x - minX][z - minZ] = this.argument.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z));
                isZero[x - minX][z - minZ] = value[x - minX][z - minZ] == 0.0;
            }
        }
        double[][] blur = io.github.orlouge.landmarks.utils.GaussianBlur.gaussianBlur(value, isZero, this.kernelRadius, this.sigma);
        double maxValue = Double.NEGATIVE_INFINITY;
        double minValue = Double.POSITIVE_INFINITY;
        double[][] dArray = blur;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double[] row;
            for (double col : row = dArray[i]) {
                maxValue = Math.max(col, maxValue);
                minValue = Math.min(col, minValue);
            }
        }
        return new Cache(blur, minValue, maxValue, minX, minZ, maxX, maxZ);
    }

    @Override
    public FunctionWithCache.Simple setCache(Object cache) {
        return new GaussianBlur(this.kernelRadius, this.sigma, this.normalize, this.key, this.argument, this.minX, this.minZ, this.maxX, this.maxZ, this.y, (Cache)cache);
    }

    private record Cache(double[][] blur, double minValue, double maxValue, int minX, int minZ, int maxX, int maxZ) {
    }
}

