/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.algorithms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.utils.OpenSimplex2;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class Noise3D
implements DensityFunction.SimpleFunction {
    public static final MapCodec<Noise3D> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Codec.DOUBLE, (Codec)DensityFunction.f_208218_).fieldOf("xz_scale").forGetter(d -> d.xzScale), (App)Codec.either((Codec)Codec.DOUBLE, (Codec)DensityFunction.f_208218_).fieldOf("y_scale").forGetter(d -> d.yScale), (App)Codec.either((Codec)Codec.LONG, (Codec)Codec.STRING).xmap(e -> (Long)e.map(l -> l, s -> s.hashCode()), Either::left).optionalFieldOf("seed", (Object)0L).forGetter(d -> d.seed)).apply((Applicative)instance, Noise3D::new));
    public static final KeyDispatchDataCodec<Noise3D> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_(CODEC);
    public final Either<Double, DensityFunction> xzScale;
    public final Either<Double, DensityFunction> yScale;
    public final long seed;

    public Noise3D(Either<Double, DensityFunction> xzScale, Either<Double, DensityFunction> yScale, long seed) {
        this.xzScale = xzScale;
        this.yScale = yScale;
        this.seed = seed;
    }

    public Noise3D create(long featureSeed) {
        return new Noise3D(this.xzScale, this.yScale, this.seed + featureSeed);
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        double xzScale = (Double)this.xzScale.map(x -> x, d -> d.m_207386_(pos));
        double yScale = (Double)this.yScale.map(x -> x, d -> d.m_207386_(pos));
        double x2 = (double)((long)pos.m_207115_() + (this.seed & 0xFFFFL)) * xzScale;
        double y = (double)((long)pos.m_207114_() + (this.seed & 0xFFFFL)) * yScale;
        double z = (double)((long)pos.m_207113_() + (this.seed & 0xFFFFL)) * xzScale;
        return OpenSimplex2.noise3_ImproveXZ(this.seed, x2, y, z);
    }

    public double m_207402_() {
        return -1.0;
    }

    public double m_207401_() {
        return 1.0;
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new Noise3D((Either<Double, DensityFunction>)this.xzScale.mapRight(d -> d.m_207456_(visitor)), (Either<Double, DensityFunction>)this.yScale.mapRight(d -> d.m_207456_(visitor)), this.seed));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC_HOLDER;
    }
}

