/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.DensityFunction;

public record FeatureBiomeMatches(List<HolderSet<Biome>> filter, List<HolderSet<Biome>> negativeFilter, WorldGenLevel world) implements DensityFunction.SimpleFunction
{
    public static final MapCodec<FeatureBiomeMatches> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).listOf().optionalFieldOf("matches", List.of()).forGetter(FeatureBiomeMatches::filter), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).listOf().optionalFieldOf("matches_not", List.of()).forGetter(FeatureBiomeMatches::negativeFilter)).apply((Applicative)instance, FeatureBiomeMatches::new));
    public static final KeyDispatchDataCodec<FeatureBiomeMatches> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_(CODEC);

    public FeatureBiomeMatches(List<HolderSet<Biome>> filter, List<HolderSet<Biome>> negativeFilter) {
        this(filter, negativeFilter, null);
    }

    public FeatureBiomeMatches create(WorldGenLevel world) {
        return new FeatureBiomeMatches(this.filter, this.negativeFilter, world);
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        if (this.world == null) {
            throw new RuntimeException("Attempted to sample FeatureBiomeMatches outside of the feature.");
        }
        Holder biome = this.world.m_204166_(new BlockPos(pos.m_207115_(), pos.m_207114_(), pos.m_207113_()));
        for (HolderSet<Biome> filter : this.filter) {
            if (filter.m_203333_(biome)) continue;
            return 0.0;
        }
        for (HolderSet<Biome> filter : this.negativeFilter) {
            if (!filter.m_203333_(biome)) continue;
            return 0.0;
        }
        return 1.0;
    }

    public double m_207402_() {
        return 0.0;
    }

    public double m_207401_() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC_HOLDER;
    }
}

