/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class FeatureCache
implements DensityFunction,
FunctionWithCache.Simple {
    public static final MapCodec<FeatureCache> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("argument").forGetter(d -> d.argument), (App)DensityFunction.f_208218_.optionalFieldOf("repeat_y").forGetter(d -> d.repeatY), (App)Codec.STRING.optionalFieldOf("key", (Object)"").forGetter(d -> d.key), (App)Codec.BOOL.optionalFieldOf("precomputed", (Object)false).forGetter(d -> d.precomputed)).apply((Applicative)instance, FeatureCache::new));
    public static final KeyDispatchDataCodec<FeatureCache> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_(CODEC);
    public final DensityFunction argument;
    public final Optional<DensityFunction> repeatY;
    public final String key;
    public final boolean precomputed;
    private final Cache cache;

    private FeatureCache(DensityFunction argument, Optional<DensityFunction> repeatY, String key, boolean precomputed, Cache cache) {
        this.argument = argument;
        this.key = key;
        this.repeatY = repeatY;
        this.cache = cache;
        this.precomputed = precomputed;
    }

    public FeatureCache(DensityFunction argument, Optional<DensityFunction> repeatY, String key, boolean precomputed) {
        this.argument = argument;
        this.key = key.isEmpty() ? null : key;
        this.repeatY = repeatY;
        this.cache = null;
        this.precomputed = precomputed;
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        boolean y2d = this.repeatY.isPresent();
        if (this.cache == null || pos.m_207115_() < this.cache.minX || pos.m_207115_() > this.cache.maxX || !y2d && (pos.m_207114_() < this.cache.minY || pos.m_207114_() > this.cache.maxY) || pos.m_207113_() < this.cache.minZ || pos.m_207113_() > this.cache.maxZ) {
            return this.sampleWithoutCache(pos);
        }
        int cacheX = pos.m_207115_() - this.cache.minX;
        int cacheY = pos.m_207114_() - this.cache.minY;
        int cacheZ = pos.m_207113_() - this.cache.minZ;
        int idx = !y2d ? (this.cache.xExt * cacheY + cacheX) * this.cache.zExt + cacheZ : this.cache.zExt * cacheX + cacheZ;
        double cachedValue = this.cache.cache[idx];
        if (Double.isNaN(cachedValue)) {
            this.cache.cache[idx] = cachedValue = this.sampleWithoutCache(pos);
        }
        return cachedValue;
    }

    private double sampleWithoutCache(DensityFunction.FunctionContext pos) {
        return this.argument.m_207386_(pos);
    }

    public double m_207402_() {
        return this.argument.m_207402_();
    }

    public double m_207401_() {
        return this.argument.m_207401_();
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new FeatureCache(this.argument.m_207456_(visitor), this.repeatY.map(d -> d.m_207456_(visitor)), this.key, this.precomputed, this.cache));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC_HOLDER;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object createCache(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        double[] cache;
        int xExt = maxX - minX + 1;
        int yExt = maxY - minY + 1;
        int zExt = maxZ - minZ + 1;
        boolean y2d = this.repeatY.isPresent();
        int fixedY = y2d ? (int)this.repeatY.get().m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) : 0;
        double[] dArray = cache = y2d ? new double[(xExt + 2) * (zExt + 2)] : new double[(xExt + 2) * (yExt + 2) * (zExt + 2)];
        if (this.precomputed) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (y2d) {
                        cache[zExt * (x - minX) + z - minZ] = this.sampleWithoutCache((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, fixedY, z));
                        continue;
                    }
                    for (int y = minY; y <= maxY; ++y) {
                        cache[(xExt * (y - minY) + x - minX) * zExt + z - minZ] = this.sampleWithoutCache((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z));
                    }
                }
            }
        } else {
            Arrays.fill(cache, Double.NaN);
        }
        return new Cache(cache, minX, maxX, minY, maxY, minZ, maxZ, xExt, zExt);
    }

    @Override
    public FunctionWithCache.Simple setCache(Object cache) {
        return new FeatureCache(this.argument, this.repeatY, this.key, this.precomputed, (Cache)cache);
    }

    private record Cache(double[] cache, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, int xExt, int zExt) {
    }
}

