/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import io.github.orlouge.landmarks.features.VariantContext;
import io.github.orlouge.landmarks.utils.RandomProperty;
import io.github.orlouge.landmarks.utils.TopologicalSort;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;

public record VariantWithFragment<T extends Fragment<T>>(Map<String, RandomProperty<String, VariantContext, VariantContext.Predicate>> subVariants, Optional<String> nameOverride, T fragment) {
    static <T extends Fragment<T>> Map<ResourceLocation, Map<String, List<RandomProperty.WrappedEntry<NamedVariant<T>, VariantContext.Predicate>>>> getChildVariants(Registry<RandomProperty.WrappedEntry<VariantWithFragment<T>, VariantContext.Predicate>> registry, T emptyFragment) {
        HashMap<ResourceLocation, Map<String, List<RandomProperty.WrappedEntry<NamedVariant<T>, VariantContext.Predicate>>>> childVariants = new HashMap<ResourceLocation, Map<String, List<RandomProperty.WrappedEntry<NamedVariant<T>, VariantContext.Predicate>>>>();
        for (Map.Entry entry : registry.m_6579_()) {
            int i;
            ResourceLocation id = ((ResourceKey)entry.getKey()).m_135782_();
            String[] parts = id.m_135815_().split("/");
            if (parts.length < 2) continue;
            StringBuilder parentPath = new StringBuilder(parts[0]);
            for (i = 1; i < parts.length - 2; ++i) {
                parentPath.append("/").append(parts[i]);
            }
            ResourceLocation parentId = ResourceLocation.m_214293_((String)id.m_135827_(), (String)parentPath.toString());
            if (parts.length == 2) {
                List entries = childVariants.computeIfAbsent(parentId, k -> new HashMap()).computeIfAbsent(parts[i], k -> new ArrayList());
                entries.add(((RandomProperty.WrappedEntry)entry.getValue()).map(variant -> new NamedVariant(variant.nameOverride.orElse("yes"), variant)));
                entries.add(new RandomProperty.WrappedEntry<NamedVariant<T>, VariantContext.Predicate>(new NamedVariant<T>("no", new VariantWithFragment<T>(Collections.emptyMap(), Optional.empty(), emptyFragment)), 1.0E-8, true, new VariantContext.Predicate()));
                continue;
            }
            String variantType = parts[i++];
            String variantName = parts[i];
            childVariants.computeIfAbsent(parentId, k -> new HashMap()).computeIfAbsent(variantType, k -> new ArrayList()).add(((RandomProperty.WrappedEntry)entry.getValue()).map(variant -> new NamedVariant(variant.nameOverride.orElse(variantName), variant)));
        }
        return childVariants;
    }

    static <T extends Fragment<T>> Tuple<T, VariantContext> getAndMerge(List<ResourceLocation> variants, T baseFragment, T emptyFragment, RandomSource random, VariantContext baseContext, RegistryAccess registryManager, ResourceKey<Registry<RandomProperty.WrappedEntry<VariantWithFragment<T>, VariantContext.Predicate>>> registryKey, Map<ResourceLocation, Map<String, List<RandomProperty.WrappedEntry<NamedVariant<T>, VariantContext.Predicate>>>> childVariants) throws RandomProperty.NoRandomMatchException {
        Registry registry = registryManager.m_175515_(registryKey);
        List<Tuple> baseVariants = variants.stream().map(id -> new Tuple(id, registry.m_123009_(ResourceKey.m_135785_((ResourceKey)registryKey, (ResourceLocation)id)).map(RandomProperty.WrappedEntry::value).orElse(new VariantWithFragment<Fragment>(Collections.emptyMap(), Optional.empty(), emptyFragment)))).toList();
        ArrayList relevantTypes = new ArrayList();
        VariantSampler<Object> sampler = new VariantSampler<Object>();
        for (Tuple variant : baseVariants) {
            sampler.addUnconditionalSubvariants((VariantWithFragment)variant.m_14419_());
            Map children = childVariants.getOrDefault(variant.m_14418_(), Collections.emptyMap());
            for (Map.Entry typeEntry : children.entrySet()) {
                sampler.addChoicesWithFragments((String)typeEntry.getKey(), new RandomProperty((List)typeEntry.getValue()));
            }
            relevantTypes.add(children.keySet());
        }
        VariantContext context = sampler.sampleContext(random, baseContext);
        Object fragment = baseFragment;
        for (int i = 0; i < baseVariants.size(); ++i) {
            fragment = fragment.merge(((VariantWithFragment)baseVariants.get(i).m_14419_()).fragment());
            fragment = sampler.mergeVariant(fragment, (Set)relevantTypes.get(i), context);
        }
        return new Tuple(fragment, (Object)context);
    }

    public static interface Fragment<T extends Fragment<T>> {
        public T merge(T var1);

        public T addVariantCondition(String var1, String var2);
    }

    public record NamedVariant<T extends Fragment<T>>(String name, VariantWithFragment<T> variant) {
    }

    public static class VariantSampler<T extends Fragment<T>> {
        private final Map<String, Set<String>> typeDeps = new HashMap<String, Set<String>>();
        private final Map<String, RandomProperty<String, VariantContext, VariantContext.Predicate>> typeSamplers = new HashMap<String, RandomProperty<String, VariantContext, VariantContext.Predicate>>();
        private final Map<String, Map<String, T>> fragments = new HashMap<String, Map<String, T>>();

        public void addChoicesWithFragments(String type, RandomProperty<NamedVariant<T>, VariantContext, VariantContext.Predicate> variants) {
            for (RandomProperty.WrappedEntry<NamedVariant<T>, VariantContext.Predicate> entry : variants.entries()) {
                VariantWithFragment<T> var = entry.value().variant();
                this.addChoiceWithFragment(type, new NamedVariant(entry.value().name, new VariantWithFragment(var.subVariants, var.nameOverride, var.fragment.addVariantCondition(type, entry.value().name))));
            }
            this.addRandomChoicesAndDependencies(type, variants.map(NamedVariant::name));
        }

        public void addChoiceWithFragment(String type, NamedVariant<T> variant) {
            for (Map.Entry<String, RandomProperty<String, VariantContext, VariantContext.Predicate>> entry : variant.variant.subVariants.entrySet()) {
                this.typeDeps.computeIfAbsent(entry.getKey(), k -> new HashSet()).add(type);
                this.addRandomChoicesAndDependencies(entry.getKey(), entry.getValue().mapPredicates(p -> p.addVariantCondition(type, variant.name)));
            }
            this.fragments.computeIfAbsent(type, k -> new HashMap()).merge(variant.name, variant.variant().fragment, Fragment::merge);
        }

        public void addUnconditionalSubvariants(VariantWithFragment<T> variant) {
            for (Map.Entry<String, RandomProperty<String, VariantContext, VariantContext.Predicate>> entry : variant.subVariants.entrySet()) {
                this.addRandomChoicesAndDependencies(entry.getKey(), entry.getValue());
            }
        }

        private void addRandomChoicesAndDependencies(String type, RandomProperty<String, VariantContext, VariantContext.Predicate> variant) {
            for (RandomProperty.WrappedEntry<String, VariantContext.Predicate> entry : variant.entries()) {
                for (String dep : entry.contextPredicate().variantsAny().map(Map::keySet).orElse(Collections.emptySet())) {
                    this.typeDeps.computeIfAbsent(type, k -> new HashSet()).add(dep);
                }
                for (String dep : entry.contextPredicate().variantsNone().map(Map::keySet).orElse(Collections.emptySet())) {
                    this.typeDeps.computeIfAbsent(type, k -> new HashSet()).add(dep);
                }
            }
            this.typeSamplers.merge(type, variant, RandomProperty::merge);
        }

        public VariantContext sampleContext(RandomSource random, VariantContext baseContext) throws RandomProperty.NoRandomMatchException {
            List<String> typeOrder = TopologicalSort.sort(this.typeSamplers.keySet(), v -> this.typeDeps.getOrDefault(v, Collections.emptySet()).stream().filter(this.typeSamplers::containsKey).toList());
            VariantContext context = baseContext.withVariants(new HashMap<String, String>());
            for (String type : typeOrder) {
                RandomProperty<String, VariantContext, VariantContext.Predicate> randomVariant = this.typeSamplers.get(type);
                try {
                    String variant = randomVariant.sample(random, context);
                    if (context.variant().containsKey(type) && !context.variant().get(type).equals(variant)) {
                        throw new RuntimeException("Contradictory choices for variant type \"" + type + "\": \"" + variant + "\", \"" + context.variant().get(type));
                    }
                    context.variant().put(type, variant);
                }
                catch (RandomProperty.NoRandomMatchException e) {
                    throw new RandomProperty.NoRandomMatchException("Variant sampling error: " + type + ", order: " + String.join((CharSequence)",", typeOrder) + ", samplers: " + String.join((CharSequence)",", this.typeSamplers.keySet()));
                }
            }
            return context;
        }

        public T mergeVariant(T base, Set<String> types, VariantContext context) {
            Fragment fragment = base;
            for (Map.Entry<String, Map<String, T>> entry : this.fragments.entrySet()) {
                if (!types.contains(entry.getKey()) || !context.variant().containsKey(entry.getKey())) continue;
                fragment = fragment.merge((Fragment)((Fragment)entry.getValue().get(context.variant().get(entry.getKey()))));
            }
            return (T)fragment;
        }
    }
}

