/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.operations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Shift(DensityFunction value, Optional<DensityFunction> xShift, Optional<DensityFunction> yShift, Optional<DensityFunction> zShift) implements DensityFunction
{
    public static final MapCodec<Shift> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("input").forGetter(Shift::value), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("x_shift").forGetter(Shift::xShift), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("y_shift").forGetter(Shift::yShift), (App)DensityFunction.HOLDER_HELPER_CODEC.optionalFieldOf("z_shift").forGetter(Shift::zShift)).apply((Applicative)instance, Shift::new));
    public static final KeyDispatchDataCodec<Shift> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    public double compute(DensityFunction.FunctionContext pos) {
        return this.value.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.blockX() + this.xShift.map(f -> (int)Math.round(f.compute(pos))).orElse(0), pos.blockY() + this.yShift.map(f -> (int)Math.round(f.compute(pos))).orElse(0), pos.blockZ() + this.zShift.map(f -> (int)Math.round(f.compute(pos))).orElse(0)));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Shift(this.value.mapAll(visitor), this.xShift.map(d -> d.mapAll(visitor)), this.yShift.map(d -> d.mapAll(visitor)), this.zShift.map(d -> d.mapAll(visitor))));
    }

    public double minValue() {
        return this.value.minValue();
    }

    public double maxValue() {
        return this.value.maxValue();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }
}

