/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.BoundedFunction;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Sphere(DensityFunction x, DensityFunction z, DensityFunction y, DensityFunction _radius, DensityFunction inside) implements DensityFunction,
BoundedFunction
{
    public static final MapCodec<Sphere> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("x").forGetter(Sphere::x), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("z").forGetter(Sphere::z), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("y").forGetter(Sphere::y), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("radius").forGetter(Sphere::_radius), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("inside").forGetter(Sphere::inside)).apply((Applicative)instance, Sphere::new));
    public static final KeyDispatchDataCodec<Sphere> CODEC_HOLDER = KeyDispatchDataCodec.of(CODEC);

    public double compute(DensityFunction.FunctionContext pos) {
        return Math.sqrt(Math.pow((double)pos.blockX() - this.x.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)), 2.0) + Math.pow((double)pos.blockY() - this.y.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)), 2.0) + Math.pow((double)pos.blockZ() - this.z.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)), 2.0)) <= this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) ? this.inside.compute(pos) : 0.0;
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Sphere(this.x.mapAll(visitor), this.z.mapAll(visitor), this.y.mapAll(visitor), this._radius.mapAll(visitor), this.inside.mapAll(visitor)));
    }

    public double minValue() {
        return Math.min(0.0, this.inside.minValue());
    }

    public double maxValue() {
        return Math.max(0.0, this.inside.maxValue());
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return CODEC_HOLDER;
    }

    @Override
    public int minX() {
        return (int)(this.x.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) - this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)));
    }

    @Override
    public int maxX() {
        return (int)(this.x.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) + this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)));
    }

    @Override
    public int minY() {
        return (int)(this.y.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) - this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)));
    }

    @Override
    public int maxY() {
        return (int)(this.y.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) + this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)));
    }

    @Override
    public int minZ() {
        return (int)(this.z.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) - this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)));
    }

    @Override
    public int maxZ() {
        return (int)(this.z.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)) + this._radius.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)));
    }
}

