/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Convolution(DensityFunction input, List<Double> kernel, Double factor) implements DensityFunction
{
    public static final MapCodec<Convolution> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("input").forGetter(Convolution::input), (App)Codec.DOUBLE.listOf().flatXmap(Convolution::checkKernelSize, Convolution::checkKernelSize).fieldOf("kernel").forGetter(Convolution::kernel), (App)Codec.DOUBLE.fieldOf("factor").forGetter(Convolution::factor)).apply((Applicative)instance, Convolution::new));
    public static final KeyDispatchDataCodec<Convolution> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_(CODEC);

    private static <T> DataResult<List<T>> checkKernelSize(List<T> k) {
        int sk = (int)Math.cbrt(k.size());
        return sk * sk * sk == k.size() && sk % 2 != 0 ? DataResult.success(k) : DataResult.error(() -> "The kernel length must be the cube of an odd number.");
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        int k = (int)Math.cbrt(this.kernel.size());
        int off = k / 2;
        double acc = 0.0;
        for (int y = -off; y <= off; ++y) {
            for (int z = -off; z <= off; ++z) {
                for (int x = -off; x <= off; ++x) {
                    double f = this.kernel.get(k * k * (y + off) + k * (z + off) + x + off);
                    if (f == 0.0) continue;
                    acc += f * this.input.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_207115_() + x, pos.m_207114_() + y, pos.m_207113_() + z));
                }
            }
        }
        return acc * this.factor;
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new Convolution(this.input.m_207456_(visitor), this.kernel, this.factor));
    }

    public double m_207402_() {
        return this.input.m_207402_();
    }

    public double m_207401_() {
        return this.input.m_207401_();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC_HOLDER;
    }
}

