/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import io.github.orlouge.landmarks.density.BorderBlurred;
import io.github.orlouge.landmarks.density.BorderChamferDistance;
import io.github.orlouge.landmarks.density.FeatureCache;
import io.github.orlouge.landmarks.density.FeatureMaxX;
import io.github.orlouge.landmarks.density.FeatureMaxY;
import io.github.orlouge.landmarks.density.FeatureMaxZ;
import io.github.orlouge.landmarks.density.FeatureMinX;
import io.github.orlouge.landmarks.density.FeatureMinY;
import io.github.orlouge.landmarks.density.FeatureMinZ;
import io.github.orlouge.landmarks.density.FeatureSurfaceY;
import io.github.orlouge.landmarks.density.FeatureUserParameter;
import io.github.orlouge.landmarks.density.Noise2D;
import io.github.orlouge.landmarks.density.Noise3D;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.levelgen.DensityFunction;

class FeatureDensityFunctionContext {
    private final Map<Long, double[][]> noise2DCache = new HashMap<Long, double[][]>();
    private final Map<String, double[]> customCache = new HashMap<String, double[]>();
    public final long seed;
    public final int minX;
    public final int maxX;
    public final int minY;
    public final int maxY;
    public final int minZ;
    public final int maxZ;
    public final int surfaceY;
    public final boolean[][] cantPlace;
    public final Map<String, Double> userParameters;

    public FeatureDensityFunctionContext(long seed, int minX, int maxX, int minY, int maxY, int minZ, int maxZ, int surfaceY, boolean[][] cantPlace, Map<String, Double> userParameters) {
        this.seed = seed;
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.minZ = minZ;
        this.maxZ = maxZ;
        this.surfaceY = surfaceY;
        this.cantPlace = cantPlace;
        this.userParameters = userParameters;
    }

    public DensityFunction.Visitor getVisitor() {
        int xExt = this.maxX - this.minX + 1;
        int yExt = this.maxY - this.minY + 1;
        int zExt = this.maxZ - this.minZ + 1;
        return function -> {
            if (function instanceof BorderChamferDistance) {
                BorderChamferDistance edgeDist = (BorderChamferDistance)function;
                return edgeDist.create(this.cantPlace, this.minX - 1, this.maxX + 1, this.minZ - 1, this.maxZ + 1);
            }
            if (function instanceof BorderBlurred) {
                BorderBlurred blur = (BorderBlurred)function;
                return blur.create(this.cantPlace, this.minX - 1, this.maxX + 1, this.minZ - 1, this.maxZ + 1);
            }
            if (function instanceof Noise3D) {
                Noise3D noise = (Noise3D)function;
                return noise.create(this.seed);
            }
            if (function instanceof Noise2D) {
                Noise2D noise = (Noise2D)function;
                double[][] cache = this.noise2DCache.computeIfAbsent(noise.seed, k -> new double[xExt][zExt]);
                return noise.create(this.seed, cache, this.minX, this.maxX, this.minZ, this.maxZ);
            }
            if (function instanceof FeatureCache) {
                FeatureCache cached = (FeatureCache)function;
                double[] cache = this.customCache.computeIfAbsent(cached.key, k -> cached.y2d ? new double[(xExt + 2) * (zExt + 2)] : new double[(xExt + 2) * (yExt + 2) * (zExt + 2)]);
                return cached.create(cache, this.minX - 1, this.maxX + 1, this.minY - 1, this.maxY + 1, this.minZ - 1, this.maxZ + 1);
            }
            if (function instanceof FeatureUserParameter) {
                FeatureUserParameter params = (FeatureUserParameter)function;
                if (this.userParameters.containsKey(params.parameter)) {
                    return params.create(this.userParameters.get(params.parameter));
                }
            }
            if (function instanceof FeatureMinY) {
                FeatureMinY param = (FeatureMinY)function;
                return param.create(this.minY);
            }
            if (function instanceof FeatureMaxY) {
                FeatureMaxY param = (FeatureMaxY)function;
                return param.create(this.maxY);
            }
            if (function instanceof FeatureSurfaceY) {
                FeatureSurfaceY param = (FeatureSurfaceY)function;
                return param.create(this.surfaceY);
            }
            if (function instanceof FeatureMinX) {
                FeatureMinX param = (FeatureMinX)function;
                return param.create(this.minX);
            }
            if (function instanceof FeatureMinZ) {
                FeatureMinZ param = (FeatureMinZ)function;
                return param.create(this.minZ);
            }
            if (function instanceof FeatureMaxX) {
                FeatureMaxX param = (FeatureMaxX)function;
                return param.create(this.maxX);
            }
            if (function instanceof FeatureMaxZ) {
                FeatureMaxZ param = (FeatureMaxZ)function;
                return param.create(this.maxZ);
            }
            return function;
        };
    }
}

