/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.utils.WeightedRandomList;
import java.util.List;
import net.minecraft.util.RandomSource;

public record RandomProperty<T, C, S extends ContextPredicate<C>>(List<WrappedEntry<T, S>> entries) {
    public SamplerCreator<T> withReplacement(C context, boolean forced) throws NoRandomMatchException {
        List<WrappedEntry> validEntries = this.entries.stream().filter(entry -> ((ContextPredicate)entry.contextPredicate).test(context)).toList();
        if (validEntries.isEmpty()) {
            if (forced) {
                System.out.println("Ignoring random constraints because there's no match.");
                validEntries = this.entries;
            } else {
                throw new NoRandomMatchException();
            }
        }
        List<WrappedEntry> sampledEntries = validEntries;
        if (validEntries.size() == 1) {
            return random -> () -> ((WrappedEntry)sampledEntries.get((int)0)).value;
        }
        return random -> {
            WeightedRandomList sampler = new WeightedRandomList();
            for (WrappedEntry entry : sampledEntries) {
                sampler.add(entry.weight, entry.value);
            }
            return () -> sampler.popSample(random);
        };
    }

    public Sampler<T> sampler(RandomSource random, C context, boolean forced) throws NoRandomMatchException {
        WeightedRandomList sampler = new WeightedRandomList();
        for (WrappedEntry<T, S> entry : this.entries) {
            if (!((ContextPredicate)entry.contextPredicate).test(context)) continue;
            sampler.add(entry.weight, entry.value);
        }
        if (sampler.size() == 0) {
            if (forced) {
                System.out.println("Ignoring random constraints because there's no match.");
                for (WrappedEntry<T, S> entry : this.entries) {
                    sampler.add(entry.weight, entry.value);
                }
            } else {
                throw new NoRandomMatchException();
            }
        }
        if (sampler.size() == 1) {
            Object entry = sampler.iterator().next();
            return () -> entry;
        }
        return () -> sampler.sample(random);
    }

    public T sample(RandomSource random, C context) throws NoRandomMatchException {
        return this.sampler(random, context, false).sample();
    }

    public static <T, C, S extends ContextPredicate<C>> RandomProperty<T, C, S> singleton(T entry, S contextPredicate) {
        return new RandomProperty<T, C, S>(List.of(new WrappedEntry<T, S>(entry, contextPredicate)));
    }

    public static <T extends Entry<S>, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> flatCodec(Codec<T> entryCodecInList, Codec<T> entryCodec, S defaultContextPredicate) {
        return Codec.either((Codec)entryCodecInList.listOf(), entryCodec).xmap(either -> (RandomProperty)either.map(entries -> new RandomProperty(entries.stream().map(entry -> new WrappedEntry<Entry, ContextPredicate>((Entry)entry, entry.getWeight(), (ContextPredicate)entry.getContextPredicate())).toList()), entry -> new RandomProperty(List.of(new WrappedEntry<Entry, ContextPredicate>((Entry)entry, defaultContextPredicate)))), prop -> prop.entries.size() == 1 ? Either.right((Object)((Entry)prop.entries.get((int)0).value)) : Either.left(prop.entries.stream().map(WrappedEntry::value).toList()));
    }

    public static <T, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> wrappedCodec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate, String valueKey) {
        Codec<WrappedEntry<T, S>> wrappedEntryCodec = WrappedEntry.codec(entryCodec, contextPredicateCodec, defaultContextPredicate, valueKey);
        return RandomProperty.flatCodec(wrappedEntryCodec, wrappedEntryCodec, defaultContextPredicate).xmap(wrapped -> new RandomProperty(wrapped.entries.stream().map(WrappedEntry::value).toList()), unwrapped -> new RandomProperty(unwrapped.entries.stream().map(WrappedEntry::wrap).toList()));
    }

    public static <T, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> wrappedCodec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate) {
        return RandomProperty.wrappedCodec(entryCodec, contextPredicateCodec, defaultContextPredicate, "input");
    }

    public static <T, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> strictWrappedCodec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate, String valueKey) {
        Codec<WrappedEntry<T, S>> listEntryCodec = WrappedEntry.strictCodec(entryCodec, contextPredicateCodec, valueKey);
        Codec<WrappedEntry<T, S>> flatEntryCodec = WrappedEntry.defaultCodec(entryCodec, defaultContextPredicate);
        return RandomProperty.flatCodec(listEntryCodec, flatEntryCodec, defaultContextPredicate).xmap(wrapped -> new RandomProperty(wrapped.entries.stream().map(WrappedEntry::value).toList()), unwrapped -> new RandomProperty(unwrapped.entries.stream().map(WrappedEntry::wrap).toList()));
    }

    public static <T, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> strictWrappedCodec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate) {
        return RandomProperty.strictWrappedCodec(entryCodec, contextPredicateCodec, defaultContextPredicate, "input");
    }

    public static <T, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> extendCodec(MapCodec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate) {
        Codec<WrappedEntry<T, S>> wrappedEntryCodec = WrappedEntry.extendCodec(entryCodec, contextPredicateCodec, defaultContextPredicate);
        return RandomProperty.flatCodec(wrappedEntryCodec, wrappedEntryCodec, defaultContextPredicate).xmap(wrapped -> new RandomProperty(wrapped.entries.stream().map(WrappedEntry::value).toList()), unwrapped -> new RandomProperty(unwrapped.entries.stream().map(WrappedEntry::wrap).toList()));
    }

    public static class NoRandomMatchException
    extends Exception {
        public NoRandomMatchException() {
        }

        public NoRandomMatchException(String message) {
            super(message);
        }
    }

    public static interface SamplerCreator<T> {
        public Sampler<T> sampler(RandomSource var1);
    }

    public record WrappedEntry<T, S>(T value, double weight, S contextPredicate) implements Entry<S>
    {
        public WrappedEntry(T value, S predicate) {
            this(value, 1.0, predicate);
        }

        private static <T, S extends ContextPredicate<?>> Codec<WrappedEntry<T, S>> strictCodec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, String valueKey) {
            return RecordCodecBuilder.create(instance -> instance.group((App)entryCodec.fieldOf(valueKey).forGetter(WrappedEntry::value), (App)Codec.DOUBLE.optionalFieldOf("weight", (Object)1.0).forGetter(WrappedEntry::weight), (App)contextPredicateCodec.forGetter(WrappedEntry::contextPredicate)).apply((Applicative)instance, WrappedEntry::new));
        }

        private static <T, S extends ContextPredicate<?>> Codec<WrappedEntry<T, S>> defaultCodec(Codec<T> entryCodec, S defaultContextPredicate) {
            return entryCodec.xmap(unwrapped -> new WrappedEntry<Object, ContextPredicate>(unwrapped, defaultContextPredicate), wrapped -> wrapped.value);
        }

        public static <T, S extends ContextPredicate<?>> Codec<WrappedEntry<T, S>> codec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate, String valueKey) {
            Codec eitherCodec = Codec.either(WrappedEntry.strictCodec(entryCodec, contextPredicateCodec, valueKey), entryCodec);
            return eitherCodec.xmap(either -> (WrappedEntry)either.map(e -> e, e -> new WrappedEntry<Object, ContextPredicate>(e, defaultContextPredicate)), wrapped -> wrapped.weight == 1.0 && ((ContextPredicate)wrapped.contextPredicate).isDefault() ? Either.right(wrapped.value) : Either.left((Object)wrapped));
        }

        public static <T, C extends ContextPredicate<?>> Codec<WrappedEntry<T, C>> extendCodec(MapCodec<T> entryCodec, MapCodec<C> contextPredicateCodec, C defaultContextPredicate) {
            Codec eitherCodec = Codec.either((Codec)RecordCodecBuilder.create(instance -> instance.group((App)entryCodec.forGetter(WrappedEntry::value), (App)Codec.DOUBLE.optionalFieldOf("weight", (Object)1.0).forGetter(WrappedEntry::weight), (App)contextPredicateCodec.forGetter(WrappedEntry::contextPredicate)).apply((Applicative)instance, WrappedEntry::new)), (Codec)entryCodec.codec());
            return eitherCodec.xmap(either -> (WrappedEntry)either.map(e -> e, e -> new WrappedEntry<Object, ContextPredicate>(e, defaultContextPredicate)), wrapped -> wrapped.weight == 1.0 && ((ContextPredicate)wrapped.contextPredicate).isDefault() ? Either.right(wrapped.value) : Either.left((Object)wrapped));
        }

        public static <T, C> WrappedEntry<WrappedEntry<T, C>, C> wrap(WrappedEntry<T, C> entry) {
            return new WrappedEntry(entry, entry.weight, entry.contextPredicate);
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        @Override
        public S getContextPredicate() {
            return this.contextPredicate;
        }
    }

    public static interface ContextPredicate<C> {
        public boolean isDefault();

        public boolean test(C var1);
    }

    public static interface Sampler<T> {
        public T sample();
    }

    public static interface Entry<S> {
        public double getWeight();

        public S getContextPredicate();
    }
}

