/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.algorithms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.BoundedFunction;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import io.github.orlouge.landmarks.utils.MaxDensitySquare;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;

public class MaxDensitySquare
implements DensityFunction,
BoundedFunction,
FunctionWithCache.Simple {
    public static final MapCodec<MaxDensitySquare> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("key", (Object)"").forGetter(s -> s.key), (App)DensityFunction.f_208218_.fieldOf("min_x").forGetter(s -> s.x1), (App)DensityFunction.f_208218_.fieldOf("max_x").forGetter(s -> s.x2), (App)DensityFunction.f_208218_.fieldOf("min_y").forGetter(s -> s.y1), (App)DensityFunction.f_208218_.fieldOf("max_y").forGetter(s -> s.y2), (App)DensityFunction.f_208218_.fieldOf("min_z").forGetter(s -> s.z1), (App)DensityFunction.f_208218_.fieldOf("max_z").forGetter(s -> s.z2), (App)DensityFunction.f_208218_.fieldOf("argument").forGetter(s -> s.density), (App)DensityFunction.f_208218_.fieldOf("min_side").forGetter(s -> s.minSide), (App)DensityFunction.f_208218_.fieldOf("max_side").forGetter(s -> s.maxSide)).apply((Applicative)instance, MaxDensitySquare::new));
    public static final KeyDispatchDataCodec<MaxDensitySquare> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_(CODEC);
    public final String key;
    public final DensityFunction x1;
    public final DensityFunction x2;
    public final DensityFunction y1;
    public final DensityFunction y2;
    public final DensityFunction z1;
    public final DensityFunction z2;
    public final DensityFunction density;
    public final DensityFunction minSide;
    public final DensityFunction maxSide;
    private final Cache cache;

    public MaxDensitySquare(String key, DensityFunction x1, DensityFunction x2, DensityFunction y1, DensityFunction y2, DensityFunction z1, DensityFunction z2, DensityFunction density, DensityFunction minSide, DensityFunction maxSide, Cache cache) {
        this.key = key;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.z1 = z1;
        this.z2 = z2;
        this.density = density;
        this.minSide = minSide;
        this.maxSide = maxSide;
        this.cache = cache;
    }

    public MaxDensitySquare(String key, DensityFunction x1, DensityFunction x2, DensityFunction y1, DensityFunction y2, DensityFunction z1, DensityFunction z2, DensityFunction density, DensityFunction minSide, DensityFunction maxSide) {
        this(key.isEmpty() ? null : key, x1, x2, y1, y2, z1, z2, density, minSide, maxSide, new Cache());
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        this.compute(pos);
        if (this.cache.invalid) {
            return 0.0;
        }
        return pos.m_207115_() >= this.cache.minX && pos.m_207115_() <= this.cache.maxX && pos.m_207114_() >= this.cache.minY && pos.m_207114_() <= this.cache.maxY && pos.m_207113_() >= this.cache.minZ && pos.m_207113_() <= this.cache.maxZ ? 1.0 : 0.0;
    }

    private void compute(DensityFunction.FunctionContext pos) {
        if (!this.cache.computed) {
            this.cache.computed = true;
            this.cache.minY = -30000000;
            this.cache.maxY = 30000000;
            int _x1 = (int)this.x1.m_207386_(pos);
            int _x2 = (int)this.x2.m_207386_(pos);
            int _y1 = (int)this.y1.m_207386_(pos);
            int _y2 = (int)this.y2.m_207386_(pos);
            int _z1 = (int)this.z1.m_207386_(pos);
            int _z2 = (int)this.z2.m_207386_(pos);
            DensityFunction densityFunction = this.density;
            if (densityFunction instanceof BoundedFunction) {
                BoundedFunction maskBounds = (BoundedFunction)densityFunction;
                _z1 = Math.max(_z1, maskBounds.minZ());
                _z2 = Math.min(_z2, maskBounds.maxZ());
                _x1 = Math.max(_x1, maskBounds.minX());
                _x2 = Math.min(_x2, maskBounds.maxX());
                _y1 = Math.max(_y1, maskBounds.minY());
                _y2 = Math.min(_y2, maskBounds.maxY());
            }
            int _minSide = (int)this.minSide.m_207386_(pos);
            int _maxSide = (int)this.maxSide.m_207386_(pos);
            if (_x2 < _x1 || _z2 < _z1 || _y2 < _y1 || _maxSide < _minSide) {
                this.cache.minX = _x2;
                this.cache.maxX = _x2;
                this.cache.minZ = _z2;
                this.cache.maxZ = _z2;
                this.cache.invalid = true;
                return;
            }
            double[][] density = new double[_x2 - _x1 + 1][_z2 - _z1 + 1];
            for (int x = _x1; x <= _x2; ++x) {
                for (int z = _z1; z <= _z2; ++z) {
                    for (int y = _y1; y <= _y2; ++y) {
                        double[] dArray = density[x - _x1];
                        int n = z - _z1;
                        dArray[n] = dArray[n] + this.density.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z));
                    }
                }
            }
            MaxDensitySquare.Result square = io.github.orlouge.landmarks.utils.MaxDensitySquare.findDenseSquare(density, 1000, RandomSource.m_216335_((long)0L), rnd -> rnd.m_216332_(_minSide, _maxSide), r -> r.density());
            this.cache.minX = _x1 + square.x();
            this.cache.maxX = this.cache.minX + square.size();
            this.cache.minZ = _z1 + square.y();
            this.cache.maxZ = this.cache.minZ + square.size();
        }
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new MaxDensitySquare(this.key, this.x1.m_207456_(visitor), this.x2.m_207456_(visitor), this.y1.m_207456_(visitor), this.y2.m_207456_(visitor), this.z1.m_207456_(visitor), this.z2.m_207456_(visitor), this.density.m_207456_(visitor), this.minSide.m_207456_(visitor), this.maxSide.m_207456_(visitor), this.cache));
    }

    public double m_207402_() {
        return 0.0;
    }

    public double m_207401_() {
        return 1.0;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC_HOLDER;
    }

    @Override
    public int minX() {
        return this.cache.minX;
    }

    @Override
    public int maxX() {
        return this.cache.maxX;
    }

    @Override
    public int minY() {
        return this.cache.minY;
    }

    @Override
    public int maxY() {
        return this.cache.maxY;
    }

    @Override
    public int minZ() {
        return this.cache.minZ;
    }

    @Override
    public int maxZ() {
        return this.cache.maxZ;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object createCache(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return new Cache();
    }

    @Override
    public FunctionWithCache.Simple setCache(Object cache) {
        MaxDensitySquare fun = new MaxDensitySquare(this.key, this.x1, this.x2, this.y1, this.y2, this.z1, this.z2, this.density, this.minSide, this.maxSide, (Cache)cache);
        fun.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0));
        return fun;
    }

    private static class Cache {
        public boolean computed = false;
        public boolean invalid = false;
        public int minX;
        public int maxX;
        public int minY;
        public int maxY;
        public int minZ;
        public int maxZ;

        private Cache() {
        }
    }
}

