/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.BoundedFunction;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public class FeatureMass
implements DensityFunction,
FunctionWithCache.Simple {
    public static final MapCodec<FeatureMass> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("argument").forGetter(d -> d.argument), (App)Codec.STRING.optionalFieldOf("key", (Object)"").forGetter(d -> d.key)).apply((Applicative)instance, FeatureMass::new));
    public static final KeyDispatchDataCodec<FeatureMass> CODEC_HOLDER = KeyDispatchDataCodec.m_216238_(CODEC);
    public final DensityFunction argument;
    public final String key;
    private final Cache cache;

    private FeatureMass(DensityFunction argument, String key, Cache cache) {
        this.argument = argument;
        this.key = key;
        this.cache = cache;
    }

    public FeatureMass(DensityFunction argument, String key) {
        this.argument = argument;
        this.key = key.isEmpty() ? null : key;
        this.cache = null;
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        if (this.cache == null) {
            throw new RuntimeException("FeatureMass sampled outside of the feature type.");
        }
        return this.cache.value;
    }

    public double m_207402_() {
        return this.cache == null ? Double.NEGATIVE_INFINITY : this.cache.value;
    }

    public double m_207401_() {
        return this.cache == null ? Double.POSITIVE_INFINITY : this.cache.value;
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new FeatureMass(this.argument.m_207456_(visitor), this.key, this.cache));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return CODEC_HOLDER;
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public Object createCache(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        double value = 0.0;
        DensityFunction densityFunction = this.argument;
        if (densityFunction instanceof BoundedFunction) {
            BoundedFunction maskBounds = (BoundedFunction)densityFunction;
            minZ = Math.max(minZ, maskBounds.minZ());
            maxZ = Math.min(maxZ, maskBounds.maxZ());
            minX = Math.max(minX, maskBounds.minX());
            maxX = Math.min(maxX, maskBounds.maxX());
            minY = Math.max(minY, maskBounds.minY());
            maxY = Math.min(maxY, maskBounds.maxY());
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    value += this.argument.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(x, y, z));
                }
            }
        }
        return new Cache(value);
    }

    @Override
    public FunctionWithCache.Simple setCache(Object cache) {
        return new FeatureMass(this.argument, this.key, (Cache)cache);
    }

    private record Cache(double value) {
    }
}

