/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import io.github.orlouge.landmarks.density.algorithms.Noise2D;
import io.github.orlouge.landmarks.density.algorithms.Noise3D;
import io.github.orlouge.landmarks.density.feature.FeatureBiomeMatches;
import io.github.orlouge.landmarks.density.feature.FeatureBlockMatches;
import io.github.orlouge.landmarks.density.feature.FeatureRandomGrid;
import io.github.orlouge.landmarks.density.feature.FeatureRandomNumber;
import io.github.orlouge.landmarks.density.feature.FeatureUserParameter;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMaxX;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMaxY;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMaxZ;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMinX;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMinY;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMinZ;
import io.github.orlouge.landmarks.density.feature.constants.FeatureOriginX;
import io.github.orlouge.landmarks.density.feature.constants.FeatureOriginY;
import io.github.orlouge.landmarks.density.feature.constants.FeatureOriginZ;
import io.github.orlouge.landmarks.features.Palette;
import io.github.orlouge.landmarks.features.Parameter;
import io.github.orlouge.landmarks.utils.RandomProperty;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record VariantContext(WorldGenLevel world, long seed, Holder<Biome> biome, Map<String, String> variant, BlockPos origin, BlockPos minPos, BlockPos maxPos, Map<String, Parameter.Sampler> userParameters, Map<String, Object> functionCache, Palette palette) {
    public static final Predicate DEFAULT_CONTEXT_PREDICATE = new Predicate();

    public static <T> Codec<RandomProperty<T, VariantContext, Predicate>> strictWrappedRandomCodec(Codec<T> entryCodec, String valueKey) {
        return RandomProperty.strictWrappedCodec(entryCodec, Predicate.CODEC, DEFAULT_CONTEXT_PREDICATE, valueKey);
    }

    public static <T> Codec<RandomProperty<T, VariantContext, Predicate>> strictWrappedRandomCodec(Codec<T> entryCodec) {
        return RandomProperty.strictWrappedCodec(entryCodec, Predicate.CODEC, DEFAULT_CONTEXT_PREDICATE);
    }

    public static <T> Codec<RandomProperty<T, VariantContext, Predicate>> extendRandomCodec(MapCodec<T> entryCodec) {
        return RandomProperty.extendCodec(entryCodec, Predicate.CODEC, DEFAULT_CONTEXT_PREDICATE);
    }

    public static <T> RandomProperty<T, VariantContext, Predicate> defaultRandomProperty(T value) {
        return RandomProperty.singleton(value, DEFAULT_CONTEXT_PREDICATE);
    }

    public static <T> Codec<RandomProperty<T, VariantContext, Predicate>> wrappedRandomCodec(Codec<T> entryCodec, String valueKey) {
        return RandomProperty.wrappedCodec(entryCodec, Predicate.CODEC, DEFAULT_CONTEXT_PREDICATE, valueKey);
    }

    public static <T> Codec<RandomProperty<T, VariantContext, Predicate>> wrappedRandomCodec(Codec<T> entryCodec) {
        return RandomProperty.wrappedCodec(entryCodec, Predicate.CODEC, DEFAULT_CONTEXT_PREDICATE);
    }

    public VariantContext withParameters(Map<String, Parameter.Sampler> localParameters) {
        HashMap<String, Parameter.Sampler> parameters = new HashMap<String, Parameter.Sampler>(this.userParameters);
        parameters.putAll(localParameters);
        return new VariantContext(this.world, this.seed, this.biome, this.variant, this.origin, this.minPos, this.maxPos, parameters, this.functionCache, this.palette);
    }

    public VariantContext withVariants(Map<String, String> newVariants) {
        HashMap<String, String> variants = new HashMap<String, String>(this.variant);
        variants.putAll(newVariants);
        return new VariantContext(this.world, this.seed, this.biome, variants, this.origin, this.minPos, this.maxPos, this.userParameters, this.functionCache, this.palette);
    }

    public VariantContext withPalette(Palette palette) {
        return new VariantContext(this.world, this.seed, this.biome, this.variant, this.origin, this.minPos, this.maxPos, this.userParameters, this.functionCache, this.palette.merge(palette));
    }

    public VariantContext withBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new VariantContext(this.world, this.seed, this.biome, this.variant, this.origin, new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ), this.userParameters, this.functionCache, this.palette);
    }

    public DensityFunction.Visitor getVisitor() {
        int minX = this.minPos.m_123341_();
        int maxX = this.maxPos.m_123341_();
        int minY = this.minPos.m_123342_();
        int maxY = this.maxPos.m_123342_();
        int minZ = this.minPos.m_123343_();
        int maxZ = this.maxPos.m_123343_();
        DensityFunction.Visitor visitor = function -> {
            FunctionWithCache.Simple cached;
            FunctionWithCache.Simple cached2;
            Noise2D noise;
            if (function instanceof Noise2D && (noise = (Noise2D)function).key() != null) {
                if (this.functionCache.containsKey(noise.key())) {
                    return noise.setCache(this.functionCache.get(noise.key()));
                }
                Noise2D noiseCached = noise.create(noise.global ? this.world.m_7328_() : this.seed, minX, maxX, minZ, maxZ);
                this.functionCache.put(noiseCached.key(), noiseCached.getCache());
                return noiseCached;
            }
            if (function instanceof FeatureRandomNumber) {
                FeatureRandomNumber random = (FeatureRandomNumber)function;
                if (this.functionCache.containsKey(random.key())) {
                    return random.setCache(this.functionCache.get(random.key()));
                }
                FeatureRandomNumber noiseCached = random.create(this.seed);
                this.functionCache.put(noiseCached.key(), noiseCached.getCache());
                return noiseCached;
            }
            if (function instanceof FeatureRandomGrid) {
                FeatureRandomGrid random = (FeatureRandomGrid)function;
                if (this.functionCache.containsKey(random.key())) {
                    return random.setCache(this.functionCache.get(random.key()));
                }
                FeatureRandomGrid noiseCached = random.create(this.seed);
                this.functionCache.put(noiseCached.key(), noiseCached.getCache());
                return noiseCached;
            }
            if (function instanceof FunctionWithCache.Simple && (cached2 = (FunctionWithCache.Simple)function).key() != null) {
                Object cache = this.functionCache.computeIfAbsent(cached2.key(), k -> cached2.createCache(minX, maxX, minY, maxY, minZ, maxZ));
                return cached2.setCache(cache);
            }
            if (function instanceof FunctionWithCache.Simple && (cached = (FunctionWithCache.Simple)function).key() == null) {
                return cached.setCache(cached.createCache(minX, maxX, minY, maxY, minZ, maxZ));
            }
            if (function instanceof Noise3D) {
                Noise3D noise2 = (Noise3D)function;
                return noise2.create(this.seed);
            }
            if (function instanceof FeatureBlockMatches) {
                FeatureBlockMatches block = (FeatureBlockMatches)function;
                return block.create(this.world);
            }
            if (function instanceof FeatureBiomeMatches) {
                FeatureBiomeMatches block = (FeatureBiomeMatches)function;
                return block.create(this.world);
            }
            if (function instanceof FeatureUserParameter) {
                FeatureUserParameter params = (FeatureUserParameter)function;
                if (this.userParameters.containsKey(params.parameter)) {
                    return params.create(this.userParameters.get(params.parameter));
                }
            }
            if (function instanceof FeatureMinY) {
                FeatureMinY param = (FeatureMinY)function;
                return param.create(minY);
            }
            if (function instanceof FeatureMaxY) {
                FeatureMaxY param = (FeatureMaxY)function;
                return param.create(maxY);
            }
            if (function instanceof FeatureOriginX) {
                FeatureOriginX param = (FeatureOriginX)function;
                return param.create(this.origin.m_123341_());
            }
            if (function instanceof FeatureOriginY) {
                FeatureOriginY param = (FeatureOriginY)function;
                return param.create(this.origin.m_123342_());
            }
            if (function instanceof FeatureOriginZ) {
                FeatureOriginZ param = (FeatureOriginZ)function;
                return param.create(this.origin.m_123343_());
            }
            if (function instanceof FeatureMinX) {
                FeatureMinX param = (FeatureMinX)function;
                return param.create(minX);
            }
            if (function instanceof FeatureMinZ) {
                FeatureMinZ param = (FeatureMinZ)function;
                return param.create(minZ);
            }
            if (function instanceof FeatureMaxX) {
                FeatureMaxX param = (FeatureMaxX)function;
                return param.create(maxX);
            }
            if (function instanceof FeatureMaxZ) {
                FeatureMaxZ param = (FeatureMaxZ)function;
                return param.create(maxZ);
            }
            return function;
        };
        return function -> {
            if (function instanceof DensityFunctions.HolderHolder) {
                DensityFunctions.HolderHolder holder = (DensityFunctions.HolderHolder)function;
                return visitor.m_214017_((DensityFunction)holder.f_208636_().m_203334_());
            }
            return visitor.m_214017_(function);
        };
    }

    public record Predicate(Optional<HolderSet<Biome>> biomes, Optional<Map<String, HashSet<String>>> variantsAny, Optional<Map<String, HashSet<String>>> variantsNone, Optional<HolderSet<Block>> originIs, Optional<List<String>> conditions) implements RandomProperty.ContextPredicate<VariantContext>
    {
        public static final MapCodec<Predicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256952_).optionalFieldOf("biome").forGetter(Predicate::biomes), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.either((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).xmap(e -> new HashSet((Collection)e.map(List::of, s -> s)), set -> Either.right(set.stream().toList()))).optionalFieldOf("has_variants").forGetter(Predicate::variantsAny), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.either((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).xmap(e -> new HashSet((Collection)e.map(List::of, s -> s)), set -> Either.right(set.stream().toList()))).optionalFieldOf("hasnt_variants").forGetter(Predicate::variantsAny), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).optionalFieldOf("origin").forGetter(Predicate::originIs), (App)Codec.STRING.listOf().optionalFieldOf("conditions").forGetter(Predicate::conditions)).apply((Applicative)instance, Predicate::new));

        public Predicate() {
            this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public Predicate addVariantCondition(String variantType, String variantName) {
            Map variantsAny = this.variantsAny.map(HashMap::new).orElse(new HashMap());
            variantsAny.put(variantType, new HashSet<String>(List.of(variantName)));
            return new Predicate(this.biomes, Optional.of(variantsAny), this.variantsNone, this.originIs, this.conditions);
        }

        @Override
        public boolean isDefault() {
            return this.biomes.isEmpty() && this.variantsAny.isEmpty() && this.variantsNone.isEmpty();
        }

        @Override
        public boolean test(VariantContext context) {
            return this.biomes.map(list -> list.m_203333_(context.biome)).orElse(true) != false && this.variantsAny.map(variantSets -> {
                for (Map.Entry entry : variantSets.entrySet()) {
                    HashSet variantSetCopy = new HashSet((Collection)entry.getValue());
                    if (variantSetCopy.contains(context.variant.getOrDefault(entry.getKey(), ""))) continue;
                    return false;
                }
                return true;
            }).orElse(true) != false && this.variantsNone.map(variantSets -> {
                for (Map.Entry entry : variantSets.entrySet()) {
                    HashSet variantSetCopy = new HashSet((Collection)entry.getValue());
                    if (!variantSetCopy.contains(context.variant.getOrDefault(entry.getKey(), ""))) continue;
                    return false;
                }
                return true;
            }).orElse(true) != false && this.originIs.map(o -> o.m_203333_(context.world.m_8055_(context.origin).m_222976_())).orElse(true) != false && this.conditions.map(c -> c.stream().allMatch(s -> Parameter.Condition.parse(s, context.userParameters).test((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(0, 0, 0)))).orElse(true) != false;
        }
    }
}

