/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.density.algorithms;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import io.github.orlouge.landmarks.utils.OpenSimplex2;
import java.util.Arrays;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public class Noise2D
implements class_6910,
FunctionWithCache {
    public static final MapCodec<Noise2D> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.either((Codec)Codec.DOUBLE, (Codec)class_6910.field_37059).fieldOf("xz_scale").forGetter(d -> d.xzScale), (App)Codec.BOOL.optionalFieldOf("global", (Object)false).forGetter(d -> d.global), (App)Codec.either((Codec)Codec.LONG, (Codec)Codec.STRING).xmap(e -> (Long)e.map(l -> l, s -> s.hashCode()), Either::left).optionalFieldOf("seed", (Object)0L).forGetter(d -> d.seed)).apply((Applicative)instance, Noise2D::new));
    public static final class_7243<Noise2D> CODEC_HOLDER = class_7243.method_42116(CODEC);
    public final Either<Double, class_6910> xzScale;
    public final boolean global;
    public final long seed;
    private final Cache cache;

    private Noise2D(Either<Double, class_6910> xzScale, boolean global, long seed, Cache cache) {
        this.xzScale = xzScale;
        this.seed = seed;
        this.cache = cache;
        this.global = global;
    }

    public Noise2D(Either<Double, class_6910> xzScale, boolean global, long seed) {
        this.xzScale = xzScale;
        this.seed = seed;
        this.cache = null;
        this.global = global;
    }

    public Noise2D create(long seed, int minX, int maxX, int minZ, int maxZ) {
        return new Noise2D(this.xzScale, this.global, this.seed, Noise2D.createCache(seed, minX, maxX, minZ, maxZ));
    }

    public double method_40464(class_6910.class_6912 pos) {
        int cacheZ;
        if (this.cache == null || pos.comp_371() < this.cache.minX || pos.comp_371() > this.cache.maxX || pos.comp_373() < this.cache.minZ || pos.comp_373() > this.cache.maxZ) {
            return this.sampleWithoutCache(pos, this.seed);
        }
        int cacheX = pos.comp_371() - this.cache.minX;
        double cachedValue = this.cache.cache[cacheX][cacheZ = pos.comp_373() - this.cache.minZ];
        if (Double.isNaN(cachedValue)) {
            this.cache.cache[cacheX][cacheZ] = cachedValue = (double)this.sampleWithoutCache(pos, this.seed + this.cache.featureSeed);
        }
        return cachedValue;
    }

    private float sampleWithoutCache(class_6910.class_6912 pos, long seed) {
        double xzScale = (Double)this.xzScale.map(x -> x, d -> d.method_40464(pos));
        double x2 = (double)((long)pos.comp_371() + (seed & 0xFFFFL)) * xzScale;
        double z = (double)((long)pos.comp_373() + (seed & 0xFFFFL)) * xzScale;
        return OpenSimplex2.noise2(seed, x2, z);
    }

    public double comp_377() {
        return -1.0;
    }

    public double comp_378() {
        return 1.0;
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new Noise2D((Either<Double, class_6910>)this.xzScale.mapRight(d -> d.method_40469(visitor)), this.global, this.seed, this.cache));
    }

    public class_7243<? extends class_6910> method_41062() {
        return CODEC_HOLDER;
    }

    @Override
    public String key() {
        return "__noise2d_" + (this.global ? "global" : "local") + "_" + this.seed;
    }

    private static Cache createCache(long featureSeed, int minX, int maxX, int minZ, int maxZ) {
        double[][] cache;
        for (double[] row : cache = new double[maxX - minX + 1][maxZ - minZ + 1]) {
            Arrays.fill(row, Double.NaN);
        }
        return new Cache(featureSeed, cache, minX, maxX, minZ, maxZ);
    }

    @Override
    public Noise2D setCache(Object cache) {
        return new Noise2D(this.xzScale, this.global, this.seed, (Cache)cache);
    }

    public Object getCache() {
        return this.cache;
    }

    private record Cache(long featureSeed, double[][] cache, int minX, int maxX, int minZ, int maxZ) {
    }
}

