/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.density.FunctionWithCache;
import io.github.orlouge.landmarks.density.algorithms.Noise2D;
import io.github.orlouge.landmarks.density.algorithms.Noise3D;
import io.github.orlouge.landmarks.density.feature.FeatureBiomeMatches;
import io.github.orlouge.landmarks.density.feature.FeatureBlockMatches;
import io.github.orlouge.landmarks.density.feature.FeatureRandomGrid;
import io.github.orlouge.landmarks.density.feature.FeatureRandomNumber;
import io.github.orlouge.landmarks.density.feature.FeatureUserParameter;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMaxX;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMaxY;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMaxZ;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMinX;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMinY;
import io.github.orlouge.landmarks.density.feature.constants.FeatureMinZ;
import io.github.orlouge.landmarks.density.feature.constants.FeatureOriginX;
import io.github.orlouge.landmarks.density.feature.constants.FeatureOriginY;
import io.github.orlouge.landmarks.density.feature.constants.FeatureOriginZ;
import io.github.orlouge.landmarks.features.Palette;
import io.github.orlouge.landmarks.features.Parameter;
import io.github.orlouge.landmarks.utils.RandomProperty;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_6910;
import net.minecraft.class_6916;
import net.minecraft.class_7924;

public record VariantContext(class_5281 world, long seed, class_6880<class_1959> biome, Map<String, String> variant, class_2338 origin, class_2338 minPos, class_2338 maxPos, Map<String, Parameter.Sampler> userParameters, Map<String, Object> functionCache, Palette palette) {
    public static final Predicate DEFAULT_CONTEXT_PREDICATE = new Predicate();

    public static <T> Codec<RandomProperty<T, VariantContext, Predicate>> strictWrappedRandomCodec(Codec<T> entryCodec, String valueKey) {
        return RandomProperty.strictWrappedCodec(entryCodec, Predicate.CODEC, DEFAULT_CONTEXT_PREDICATE, valueKey);
    }

    public static <T> Codec<RandomProperty<T, VariantContext, Predicate>> strictWrappedRandomCodec(Codec<T> entryCodec) {
        return RandomProperty.strictWrappedCodec(entryCodec, Predicate.CODEC, DEFAULT_CONTEXT_PREDICATE);
    }

    public static <T> Codec<RandomProperty<T, VariantContext, Predicate>> extendRandomCodec(MapCodec<T> entryCodec) {
        return RandomProperty.extendCodec(entryCodec, Predicate.CODEC, DEFAULT_CONTEXT_PREDICATE);
    }

    public static <T> RandomProperty<T, VariantContext, Predicate> defaultRandomProperty(T value) {
        return RandomProperty.singleton(value, DEFAULT_CONTEXT_PREDICATE);
    }

    public static <T> Codec<RandomProperty<T, VariantContext, Predicate>> wrappedRandomCodec(Codec<T> entryCodec, String valueKey) {
        return RandomProperty.wrappedCodec(entryCodec, Predicate.CODEC, DEFAULT_CONTEXT_PREDICATE, valueKey);
    }

    public static <T> Codec<RandomProperty<T, VariantContext, Predicate>> wrappedRandomCodec(Codec<T> entryCodec) {
        return RandomProperty.wrappedCodec(entryCodec, Predicate.CODEC, DEFAULT_CONTEXT_PREDICATE);
    }

    public VariantContext withParameters(Map<String, Parameter.Sampler> localParameters) {
        HashMap<String, Parameter.Sampler> parameters = new HashMap<String, Parameter.Sampler>(this.userParameters);
        parameters.putAll(localParameters);
        return new VariantContext(this.world, this.seed, this.biome, this.variant, this.origin, this.minPos, this.maxPos, parameters, this.functionCache, this.palette);
    }

    public VariantContext withVariants(Map<String, String> newVariants) {
        HashMap<String, String> variants = new HashMap<String, String>(this.variant);
        variants.putAll(newVariants);
        return new VariantContext(this.world, this.seed, this.biome, variants, this.origin, this.minPos, this.maxPos, this.userParameters, this.functionCache, this.palette);
    }

    public VariantContext withPalette(Palette palette) {
        return new VariantContext(this.world, this.seed, this.biome, this.variant, this.origin, this.minPos, this.maxPos, this.userParameters, this.functionCache, this.palette.merge(palette));
    }

    public VariantContext withBounds(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new VariantContext(this.world, this.seed, this.biome, this.variant, this.origin, new class_2338(minX, minY, minZ), new class_2338(maxX, maxY, maxZ), this.userParameters, this.functionCache, this.palette);
    }

    public class_6910.class_6915 getVisitor() {
        int minX = this.minPos.method_10263();
        int maxX = this.maxPos.method_10263();
        int minY = this.minPos.method_10264();
        int maxY = this.maxPos.method_10264();
        int minZ = this.minPos.method_10260();
        int maxZ = this.maxPos.method_10260();
        class_6910.class_6915 visitor = function -> {
            class_6910 selector0$temp = function;
            int index$1 = 0;
            block20: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Noise2D.class, FeatureRandomNumber.class, FeatureRandomGrid.class, FunctionWithCache.Simple.class, FunctionWithCache.Simple.class, Noise3D.class, FeatureBlockMatches.class, FeatureBiomeMatches.class, FeatureUserParameter.class, FeatureMinY.class, FeatureMaxY.class, FeatureOriginX.class, FeatureOriginY.class, FeatureOriginZ.class, FeatureMinX.class, FeatureMinZ.class, FeatureMaxX.class, FeatureMaxZ.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        Noise2D noise = (Noise2D)selector0$temp;
                        if (noise.key() == null) {
                            index$1 = 1;
                            continue block20;
                        }
                        if (this.functionCache.containsKey(noise.key())) {
                            return noise.setCache(this.functionCache.get(noise.key()));
                        }
                        Noise2D noiseCached = noise.create(noise.global ? this.world.method_8412() : this.seed, minX, maxX, minZ, maxZ);
                        this.functionCache.put(noiseCached.key(), noiseCached.getCache());
                        return noiseCached;
                    }
                    case 1: {
                        FeatureRandomNumber random = (FeatureRandomNumber)selector0$temp;
                        if (this.functionCache.containsKey(random.key())) {
                            return random.setCache(this.functionCache.get(random.key()));
                        }
                        FeatureRandomNumber noiseCached = random.create(this.seed);
                        this.functionCache.put(noiseCached.key(), noiseCached.getCache());
                        return noiseCached;
                    }
                    case 2: {
                        FeatureRandomGrid random = (FeatureRandomGrid)selector0$temp;
                        if (this.functionCache.containsKey(random.key())) {
                            return random.setCache(this.functionCache.get(random.key()));
                        }
                        FeatureRandomGrid noiseCached = random.create(this.seed);
                        this.functionCache.put(noiseCached.key(), noiseCached.getCache());
                        return noiseCached;
                    }
                    case 3: {
                        FunctionWithCache.Simple cached = (FunctionWithCache.Simple)selector0$temp;
                        if (cached.key() == null) {
                            index$1 = 4;
                            continue block20;
                        }
                        Object cache = this.functionCache.computeIfAbsent(cached.key(), k -> cached.createCache(minX, maxX, minY, maxY, minZ, maxZ));
                        return cached.setCache(cache);
                    }
                    case 4: {
                        FunctionWithCache.Simple cached = (FunctionWithCache.Simple)selector0$temp;
                        if (cached.key() != null) {
                            index$1 = 5;
                            continue block20;
                        }
                        return cached.setCache(cached.createCache(minX, maxX, minY, maxY, minZ, maxZ));
                    }
                    case 5: {
                        Noise3D noise = (Noise3D)selector0$temp;
                        return noise.create(this.seed);
                    }
                    case 6: {
                        FeatureBlockMatches block = (FeatureBlockMatches)selector0$temp;
                        return block.create(this.world);
                    }
                    case 7: {
                        FeatureBiomeMatches block = (FeatureBiomeMatches)selector0$temp;
                        return block.create(this.world);
                    }
                    case 8: {
                        FeatureUserParameter params = (FeatureUserParameter)selector0$temp;
                        if (!this.userParameters.containsKey(params.parameter)) {
                            index$1 = 9;
                            continue block20;
                        }
                        return params.create(this.userParameters.get(params.parameter));
                    }
                    case 9: {
                        FeatureMinY param = (FeatureMinY)selector0$temp;
                        return param.create(minY);
                    }
                    case 10: {
                        FeatureMaxY param = (FeatureMaxY)selector0$temp;
                        return param.create(maxY);
                    }
                    case 11: {
                        FeatureOriginX param = (FeatureOriginX)selector0$temp;
                        return param.create(this.origin.method_10263());
                    }
                    case 12: {
                        FeatureOriginY param = (FeatureOriginY)selector0$temp;
                        return param.create(this.origin.method_10264());
                    }
                    case 13: {
                        FeatureOriginZ param = (FeatureOriginZ)selector0$temp;
                        return param.create(this.origin.method_10260());
                    }
                    case 14: {
                        FeatureMinX param = (FeatureMinX)selector0$temp;
                        return param.create(minX);
                    }
                    case 15: {
                        FeatureMinZ param = (FeatureMinZ)selector0$temp;
                        return param.create(minZ);
                    }
                    case 16: {
                        FeatureMaxX param = (FeatureMaxX)selector0$temp;
                        return param.create(maxX);
                    }
                    case 17: {
                        FeatureMaxZ param = (FeatureMaxZ)selector0$temp;
                        return param.create(maxZ);
                    }
                }
                break;
            }
            return function;
        };
        return function -> {
            class_6880 function2;
            if (!(function instanceof class_6916.class_7051)) return visitor.apply(function);
            class_6916.class_7051 $b$0 = (class_6916.class_7051)function;
            try {
                class_6880 patt1$temp;
                function2 = patt1$temp = $b$0.comp_468();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return visitor.apply((class_6910)function2.comp_349());
        };
    }

    public record Predicate(Optional<class_6885<class_1959>> biomes, Optional<Map<String, HashSet<String>>> variantsAny, Optional<Map<String, HashSet<String>>> variantsNone, Optional<class_6885<class_2248>> originIs, Optional<List<String>> conditions) implements RandomProperty.ContextPredicate<VariantContext>
    {
        public static final MapCodec<Predicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41236).optionalFieldOf("biome").forGetter(Predicate::biomes), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.either((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).xmap(e -> new HashSet((Collection)e.map(List::of, s -> s)), set -> Either.right(set.stream().toList()))).optionalFieldOf("has_variants").forGetter(Predicate::variantsAny), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.either((Codec)Codec.STRING, (Codec)Codec.STRING.listOf()).xmap(e -> new HashSet((Collection)e.map(List::of, s -> s)), set -> Either.right(set.stream().toList()))).optionalFieldOf("hasnt_variants").forGetter(Predicate::variantsAny), (App)class_6895.method_40340((class_5321)class_7924.field_41254).optionalFieldOf("origin").forGetter(Predicate::originIs), (App)Codec.STRING.listOf().optionalFieldOf("conditions").forGetter(Predicate::conditions)).apply((Applicative)instance, Predicate::new));

        public Predicate() {
            this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }

        public Predicate addVariantCondition(String variantType, String variantName) {
            Map variantsAny = this.variantsAny.map(HashMap::new).orElse(new HashMap());
            variantsAny.put(variantType, new HashSet<String>(List.of(variantName)));
            return new Predicate(this.biomes, Optional.of(variantsAny), this.variantsNone, this.originIs, this.conditions);
        }

        @Override
        public boolean isDefault() {
            return this.biomes.isEmpty() && this.variantsAny.isEmpty() && this.variantsNone.isEmpty();
        }

        @Override
        public boolean test(VariantContext context) {
            return this.biomes.map(list -> list.method_40241(context.biome)).orElse(true) != false && this.variantsAny.map(variantSets -> {
                for (Map.Entry entry : variantSets.entrySet()) {
                    HashSet variantSetCopy = new HashSet((Collection)entry.getValue());
                    if (variantSetCopy.contains(context.variant.getOrDefault(entry.getKey(), ""))) continue;
                    return false;
                }
                return true;
            }).orElse(true) != false && this.variantsNone.map(variantSets -> {
                for (Map.Entry entry : variantSets.entrySet()) {
                    HashSet variantSetCopy = new HashSet((Collection)entry.getValue());
                    if (!variantSetCopy.contains(context.variant.getOrDefault(entry.getKey(), ""))) continue;
                    return false;
                }
                return true;
            }).orElse(true) != false && this.originIs.map(o -> o.method_40241(context.world.method_8320(context.origin.method_10069(0, -1, 0)).method_41520())).orElse(true) != false && this.conditions.map(c -> c.stream().allMatch(s -> Parameter.Condition.parse(s, context.userParameters).test((class_6910.class_6912)new class_6910.class_6914(0, 0, 0)))).orElse(true) != false;
        }
    }
}

