/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class TopologicalSort {
    public static <T> List<T> sort(Collection<T> allObjects, Function<T, Collection<T>> getDependencies) {
        HashMap visited = new HashMap();
        ArrayList result = new ArrayList();
        for (T obj : allObjects) {
            if (visited.get(obj) != null) continue;
            TopologicalSort.dfs(obj, getDependencies, visited, result);
        }
        return result;
    }

    private static <T> void dfs(T node, Function<T, Collection<T>> getDependencies, Map<T, VisitState> visited, List<T> result) {
        VisitState state = visited.get(node);
        if (state == VisitState.VISITING) {
            throw new IllegalStateException("Cycle detected involving: " + String.valueOf(node));
        }
        if (state == VisitState.VISITED) {
            return;
        }
        visited.put(node, VisitState.VISITING);
        for (T dep : getDependencies.apply(node)) {
            TopologicalSort.dfs(dep, getDependencies, visited, result);
        }
        visited.put(node, VisitState.VISITED);
        result.add(node);
    }

    private static enum VisitState {
        VISITING,
        VISITED;

    }
}

