/*
 * Decompiled with CFR 0.152.
 */
package io.github.orlouge.landmarks.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.orlouge.landmarks.utils.RandomWrapper;
import io.github.orlouge.landmarks.utils.WeightedRandomList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_5819;

public record RandomProperty<T, C, S extends ContextPredicate<C>>(List<WrappedEntry<T, S>> entries) implements RandomWrapper<T, C>
{
    public SamplerCreator<T> withoutReplacement(C context, boolean forced, boolean sampleFallbackAfter) throws NoRandomMatchException {
        List<WrappedEntry> sampledEntries;
        List<WrappedEntry> validEntries = this.entries.stream().filter(entry -> !entry.fallback && entry.weight > 0.0 && ((ContextPredicate)entry.contextPredicate).test(context)).toList();
        List<WrappedEntry> fallbackEntries = this.entries.stream().filter(entry -> entry.fallback && entry.weight > 0.0 && ((ContextPredicate)entry.contextPredicate).test(context)).toList();
        if (validEntries.isEmpty() && fallbackEntries.isEmpty()) {
            if (forced) {
                System.out.println("Ignoring random constraints because there's no match.");
                validEntries = this.entries.stream().filter(w -> !w.isFallback()).toList();
                fallbackEntries = this.entries.stream().filter(WrappedEntry::isFallback).toList();
            } else {
                throw new NoRandomMatchException();
            }
        }
        if (sampleFallbackAfter) {
            List<WrappedEntry> sampledEntries2 = validEntries;
            List<WrappedEntry> sampledFallbackEntries = fallbackEntries;
            return random -> {
                WeightedRandomList sampler = new WeightedRandomList();
                WeightedRandomList fallbackSampler = new WeightedRandomList();
                for (WrappedEntry entry : sampledEntries2) {
                    sampler.add(entry.weight, entry.value);
                }
                for (WrappedEntry entry : sampledFallbackEntries) {
                    fallbackSampler.add(entry.weight, entry.value);
                }
                return () -> {
                    Object sample = sampler.popSample(random);
                    if (sample == null) {
                        return fallbackSampler.popSample(random);
                    }
                    return sample;
                };
            };
        }
        List<WrappedEntry> list = sampledEntries = !validEntries.isEmpty() ? validEntries : fallbackEntries;
        if (sampledEntries.size() == 1) {
            return random -> {
                boolean[] sampled = new boolean[1];
                return () -> {
                    if (sampled[0]) {
                        return null;
                    }
                    sampled[0] = true;
                    return ((WrappedEntry)sampledEntries.getFirst()).value;
                };
            };
        }
        return random -> {
            WeightedRandomList sampler = new WeightedRandomList();
            for (WrappedEntry entry : sampledEntries) {
                sampler.add(entry.weight, entry.value);
            }
            return () -> sampler.popSample(random);
        };
    }

    public Sampler<T> sampler(class_5819 random, C context, boolean forced) throws NoRandomMatchException {
        WeightedRandomList sampler;
        WeightedRandomList regularSampler = new WeightedRandomList();
        WeightedRandomList fallbackSampler = new WeightedRandomList();
        for (WrappedEntry entry : this.entries) {
            if (!(entry.weight > 0.0) || !((ContextPredicate)entry.contextPredicate).test(context)) continue;
            (entry.fallback ? fallbackSampler : regularSampler).add(entry.weight, entry.value);
        }
        if (regularSampler.size() + fallbackSampler.size() == 0) {
            if (forced) {
                System.out.println("Ignoring random constraints because there's no match.");
                for (WrappedEntry entry : this.entries) {
                    (entry.fallback ? fallbackSampler : regularSampler).add(entry.weight, entry.value);
                }
            } else {
                throw new NoRandomMatchException();
            }
        }
        WeightedRandomList weightedRandomList = sampler = regularSampler.size() > 0 ? regularSampler : fallbackSampler;
        if (sampler.size() == 1) {
            WrappedEntry entry;
            entry = sampler.iterator().next();
            return () -> entry;
        }
        return () -> sampler.sample(random);
    }

    @Override
    public T sample(class_5819 random, C context) throws NoRandomMatchException {
        return this.sampler(random, context, false).sample();
    }

    public <U> RandomProperty<U, C, S> map(Function<T, U> fun) {
        return new RandomProperty<T, C, S>(this.entries.stream().map((? super T wrapped) -> wrapped.map(fun)).toList());
    }

    public RandomProperty<T, C, S> mapPredicates(Function<S, S> fun) {
        return new RandomProperty<T, C, S>(this.entries.stream().map((? super T wrapped) -> wrapped.mapPredicate(fun)).toList());
    }

    public RandomProperty<T, C, S> merge(RandomProperty<T, C, S> other) {
        return new RandomProperty<T, C, S>(Stream.concat(this.entries.stream(), other.entries().stream()).toList());
    }

    public static <T, C, S extends ContextPredicate<C>> RandomProperty<T, C, S> singleton(T entry, S contextPredicate) {
        return new RandomProperty<T, C, S>(List.of(new WrappedEntry<T, S>(entry, contextPredicate)));
    }

    public static <T extends Entry<S>, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> flatCodec(Codec<T> entryCodecInList, Codec<T> entryCodec, S defaultContextPredicate) {
        return Codec.either((Codec)entryCodecInList.listOf(1, Integer.MAX_VALUE), entryCodec).xmap(either -> (RandomProperty)either.map(entries -> new RandomProperty(entries.stream().map((? super T entry) -> new WrappedEntry<Entry, ContextPredicate>((Entry)entry, entry.getWeight(), entry.isFallback(), (ContextPredicate)entry.getContextPredicate())).toList()), entry -> new RandomProperty(List.of(new WrappedEntry<Entry, ContextPredicate>((Entry)entry, defaultContextPredicate)))), prop -> prop.entries.size() == 1 ? Either.right((Object)((Entry)prop.entries.getFirst().value)) : Either.left(prop.entries.stream().map(WrappedEntry::value).toList()));
    }

    public static <T, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> wrappedCodec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate, String valueKey) {
        Codec<WrappedEntry<T, S>> wrappedEntryCodec = WrappedEntry.codec(entryCodec, contextPredicateCodec, defaultContextPredicate, valueKey);
        return RandomProperty.flatCodec(wrappedEntryCodec, wrappedEntryCodec, defaultContextPredicate).xmap(wrapped -> new RandomProperty(wrapped.entries.stream().map(WrappedEntry::value).toList()), unwrapped -> new RandomProperty(unwrapped.entries.stream().map(WrappedEntry::wrap).toList()));
    }

    public static <T, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> wrappedCodec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate) {
        return RandomProperty.wrappedCodec(entryCodec, contextPredicateCodec, defaultContextPredicate, "value");
    }

    public static <T, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> strictWrappedCodec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate, String valueKey) {
        Codec<WrappedEntry<T, S>> listEntryCodec = WrappedEntry.strictCodec(entryCodec, contextPredicateCodec, valueKey);
        Codec<WrappedEntry<T, S>> flatEntryCodec = WrappedEntry.defaultCodec(entryCodec, defaultContextPredicate);
        return RandomProperty.flatCodec(listEntryCodec, flatEntryCodec, defaultContextPredicate).xmap(wrapped -> new RandomProperty(wrapped.entries.stream().map(WrappedEntry::value).toList()), unwrapped -> new RandomProperty(unwrapped.entries.stream().map(WrappedEntry::wrap).toList()));
    }

    public static <T, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> strictWrappedCodec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate) {
        return RandomProperty.strictWrappedCodec(entryCodec, contextPredicateCodec, defaultContextPredicate, "value");
    }

    public static <T, C, S extends ContextPredicate<C>> Codec<RandomProperty<T, C, S>> extendCodec(MapCodec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate) {
        Codec<WrappedEntry<T, S>> wrappedEntryCodec = WrappedEntry.extendCodec(entryCodec, contextPredicateCodec);
        return RandomProperty.flatCodec(wrappedEntryCodec, wrappedEntryCodec, defaultContextPredicate).xmap(wrapped -> new RandomProperty(wrapped.entries.stream().map(WrappedEntry::value).toList()), unwrapped -> new RandomProperty(unwrapped.entries.stream().map(WrappedEntry::wrap).toList()));
    }

    public static class NoRandomMatchException
    extends Exception {
        public NoRandomMatchException() {
        }

        public NoRandomMatchException(String message) {
            super(message);
        }
    }

    public static interface SamplerCreator<T> {
        public Sampler<T> sampler(class_5819 var1);
    }

    public record WrappedEntry<T, S>(T value, double weight, boolean fallback, S contextPredicate) implements Entry<S>
    {
        private static final Codec<Double> WEIGHT_CODEC = Codec.either((Codec)Codec.doubleRange((double)1.0E-8, (double)9.99999999999E7), (Codec)Codec.doubleRange((double)0.0, (double)0.0)).xmap(e -> (Double)e.map(x -> x, x -> x), e -> e == 0.0 ? Either.right((Object)e) : Either.left((Object)0.0));

        public WrappedEntry(T value, S predicate) {
            this(value, 1.0, false, predicate);
        }

        private static <T, S extends ContextPredicate<?>> Codec<WrappedEntry<T, S>> strictCodec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, String valueKey) {
            return RecordCodecBuilder.create(instance -> instance.group((App)entryCodec.fieldOf(valueKey).forGetter(WrappedEntry::value), (App)WEIGHT_CODEC.optionalFieldOf("weight", (Object)1.0).forGetter(WrappedEntry::weight), (App)Codec.BOOL.optionalFieldOf("fallback", (Object)false).forGetter(WrappedEntry::fallback), (App)contextPredicateCodec.forGetter(WrappedEntry::contextPredicate)).apply((Applicative)instance, WrappedEntry::new));
        }

        private static <T, S extends ContextPredicate<?>> Codec<WrappedEntry<T, S>> defaultCodec(Codec<T> entryCodec, S defaultContextPredicate) {
            return entryCodec.xmap(unwrapped -> new WrappedEntry<Object, ContextPredicate>(unwrapped, defaultContextPredicate), wrapped -> wrapped.value);
        }

        public static <T, S extends ContextPredicate<?>> Codec<WrappedEntry<T, S>> codec(Codec<T> entryCodec, MapCodec<S> contextPredicateCodec, S defaultContextPredicate, String valueKey) {
            Codec eitherCodec = Codec.either(WrappedEntry.strictCodec(entryCodec, contextPredicateCodec, valueKey), entryCodec);
            return eitherCodec.xmap(either -> (WrappedEntry)either.map(e -> e, e -> new WrappedEntry<Object, ContextPredicate>(e, defaultContextPredicate)), wrapped -> wrapped.weight == 1.0 && ((ContextPredicate)wrapped.contextPredicate).isDefault() ? Either.right(wrapped.value) : Either.left((Object)wrapped));
        }

        public static <T, C extends ContextPredicate<?>> Codec<WrappedEntry<T, C>> extendCodec(MapCodec<T> entryCodec, MapCodec<C> contextPredicateCodec) {
            Codec extendedCodec = RecordCodecBuilder.create(instance -> instance.group((App)entryCodec.forGetter(WrappedEntry::value), (App)WEIGHT_CODEC.optionalFieldOf("weight", (Object)1.0).forGetter(WrappedEntry::weight), (App)Codec.BOOL.optionalFieldOf("fallback", (Object)false).forGetter(WrappedEntry::fallback), (App)contextPredicateCodec.forGetter(WrappedEntry::contextPredicate)).apply((Applicative)instance, WrappedEntry::new));
            return extendedCodec;
        }

        public static <T, C> WrappedEntry<WrappedEntry<T, C>, C> wrap(WrappedEntry<T, C> entry) {
            return new WrappedEntry(entry, entry.weight, entry.fallback, entry.contextPredicate);
        }

        public <U> WrappedEntry<U, S> map(Function<T, U> map) {
            return new WrappedEntry<U, S>(map.apply(this.value), this.weight, this.fallback, this.contextPredicate);
        }

        public WrappedEntry<T, S> mapPredicate(Function<S, S> map) {
            return new WrappedEntry<T, S>(this.value, this.weight, this.fallback, map.apply(this.contextPredicate));
        }

        @Override
        public double getWeight() {
            return this.weight;
        }

        @Override
        public boolean isFallback() {
            return this.fallback;
        }

        @Override
        public S getContextPredicate() {
            return this.contextPredicate;
        }
    }

    public static interface ContextPredicate<C> {
        public boolean isDefault();

        public boolean test(C var1);
    }

    public static interface Sampler<T> {
        public T sample();
    }

    public static interface Entry<S> {
        public double getWeight();

        public boolean isFallback();

        public S getContextPredicate();
    }
}

