/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.enderbuff;

import com.easeon.ss.enderbuff.Easeon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_DIR = new File("config/easeon");
    private static final File CONFIG_FILE = new File(CONFIG_DIR, "easeon.ss.enderbuff.json");
    private boolean enabled = true;
    private int requiredOpLevel = 2;
    private int tickInterval = 20;

    public void load() {
        if (!CONFIG_FILE.exists()) {
            this.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
            if (data != null) {
                this.enabled = data.enabled;
                this.requiredOpLevel = data.requiredOpLevel;
                this.tickInterval = data.tickInterval;
            }
            Easeon.LOGGER.info("Config loaded: enabled = {}, required OP level = {}, tick interval = {}", new Object[]{this.enabled, this.requiredOpLevel, this.tickInterval});
        }
        catch (IOException e) {
            Easeon.LOGGER.error("Failed to load config", (Throwable)e);
        }
    }

    public void save() {
        try {
            if (!CONFIG_DIR.exists()) {
                CONFIG_DIR.mkdirs();
            }
            ConfigData data = new ConfigData();
            data.enabled = this.enabled;
            data.requiredOpLevel = this.requiredOpLevel;
            data.tickInterval = this.tickInterval;
            try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                GSON.toJson((Object)data, (Appendable)writer);
            }
            Easeon.LOGGER.info("Config saved: enabled = {}, required OP level = {}, tick interval = {}", new Object[]{this.enabled, this.requiredOpLevel, this.tickInterval});
        }
        catch (IOException e) {
            Easeon.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.save();
    }

    public int getRequiredOpLevel() {
        return this.requiredOpLevel;
    }

    public int getTickInterval() {
        return this.tickInterval;
    }

    private static class ConfigData {
        public boolean enabled = true;
        public int requiredOpLevel = 2;
        public int tickInterval = 8;

        private ConfigData() {
        }
    }
}

