/*
 * Decompiled with CFR 0.152.
 */
package com.easeon.ss.enderbuff;

import com.easeon.ss.core.wrapper.EaseonItem;
import com.easeon.ss.core.wrapper.EaseonPlayer;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1730;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_3222;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class EaseonServerTickHandler {
    private static final int[][] slots = new int[][]{{6, 7, 8}, {15, 16, 17}, {24, 25, 26}};
    private static final int duration = 300;

    public static void onServerTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            EaseonServerTickHandler.applyEnderBuffs(new EaseonPlayer(player));
        }
    }

    private static void applyEnderBuffs(EaseonPlayer player) {
        class_1730 enderChest = player.getEnderChest();
        for (int[] slot : slots) {
            int blockCount;
            int appleCount;
            int healthBoostLevel;
            int level;
            EaseonItem item = new EaseonItem(enderChest.method_5438(slot[0]));
            EaseonItem totem = new EaseonItem(enderChest.method_5438(slot[1]));
            EaseonItem block = new EaseonItem(enderChest.method_5438(slot[2]));
            boolean isTotem = totem.of(new class_1792[]{class_1802.field_8288});
            int n = block.of(new class_1792[]{class_1802.field_8603}) ? 0 : (level = block.of(new class_1792[]{class_1802.field_22018}) ? 1 : -1);
            if (!isTotem || level < 0 || item.isEmpty() || item.isDamaged()) continue;
            if (item.of(new class_1792[]{class_1802.field_8574, class_1802.field_8436, class_1802.field_8150})) {
                class_1844 potion = (class_1844)item.get().method_58694(class_9334.field_49651);
                if (potion == null) continue;
                for (class_1293 effect : potion.method_57397()) {
                    if (effect.method_5578() != level) continue;
                    player.addEffect(effect.method_5579(), 300, level);
                }
                continue;
            }
            if (item.of(new class_1792[]{class_1802.field_8377, class_1802.field_22024})) {
                if (EaseonServerTickHandler.getAmplifier(item) != level) continue;
                player.addEffect(class_1294.field_5917, 300, level);
                continue;
            }
            if (item.of(new class_1792[]{class_1802.field_8058, class_1802.field_22028})) {
                if (EaseonServerTickHandler.getAmplifier(item) != level) continue;
                player.addEffect(class_1294.field_5907, 300, level);
                continue;
            }
            if (item.of(new class_1792[]{class_1802.field_8140}) && level == 1) {
                player.addEffect(class_1294.field_5927, 300, level);
                continue;
            }
            if (item.of(new class_1792[]{class_1802.field_8367}) && level == 0) {
                player.addEffect(class_1294.field_5922, 300, 0);
                continue;
            }
            if (!item.of(new class_1792[]{class_1802.field_8367}) || level != 1 || (healthBoostLevel = Math.min(appleCount = item.getCount(), blockCount = block.getCount()) - 1) < 0) continue;
            player.addEffect(class_1294.field_5914, 300, healthBoostLevel);
        }
    }

    private static int getAmplifier(EaseonItem item) {
        return item.of(new class_1792[]{class_1802.field_8377, class_1802.field_8058}) ? 0 : 1;
    }
}

