/*
 * Decompiled with CFR 0.152.
 */
package com.anningui.modifyjs.builder.item.armor;

import com.anningui.modifyjs.builder.item.RenderItemBuilder;
import com.anningui.modifyjs.callback.ArmorLayerContext;
import com.anningui.modifyjs.render.item.KJSClientItemExtensions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import dev.latvian.mods.kubejs.item.MutableArmorTier;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderArmorItem
extends ArmorItem {
    private final Multimap<ResourceLocation, AttributeModifier> attributes;
    private final Builder builder;
    private boolean modified = false;

    public RenderArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties, Multimap<ResourceLocation, AttributeModifier> attributes, Builder builder) {
        super(material, type, properties);
        this.f_40383_ = ArrayListMultimap.create((Multimap)this.f_40383_);
        this.attributes = attributes;
        this.builder = builder;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot equipmentSlot) {
        if (!this.modified) {
            this.modified = true;
            this.attributes.forEach((r, m) -> this.f_40383_.put((Object)((Attribute)RegistryInfo.ATTRIBUTE.getValue(r)), m));
        }
        return super.m_7167_(equipmentSlot);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        if (this.builder.noShowArmorModel) {
            return "modifyjs:textures/models/armor/blank_armor.png";
        }
        return null;
    }

    @Nullable
    public Builder kjs$getItemBuilder() {
        return this.builder;
    }

    public static class Builder
    extends RenderItemBuilder {
        @HideFromJS
        public static Map<ResourceLocation, Builder> instances = new HashMap<ResourceLocation, Builder>();
        public final ArmorItem.Type armorType;
        public MutableArmorTier armorTier;
        @HideFromJS
        public boolean noShowArmorModel = false;
        public static Map<Builder, Consumer<ArmorLayerContext>> allArmorLayers = new HashMap<Builder, Consumer<ArmorLayerContext>>();

        public Builder(ResourceLocation i, ArmorItem.Type t) {
            super(i);
            this.armorType = t;
            this.armorTier = new MutableArmorTier(this.id.toString(), (ArmorMaterial)ArmorMaterials.IRON);
            this.unstackable();
            instances.put(i, this);
        }

        public Builder tier(ArmorMaterial t) {
            this.armorTier = new MutableArmorTier(t.m_6082_(), t);
            return this;
        }

        public Builder modifyTier(Consumer<MutableArmorTier> callback) {
            callback.accept(this.armorTier);
            return this;
        }

        public Builder addLayerRender(Consumer<ArmorLayerContext> callback) {
            allArmorLayers.put(this, callback);
            return this;
        }

        public Builder noDefaultRender() {
            this.noShowArmorModel = true;
            return this;
        }

        @Override
        public Item createObject() {
            if (this.mjs$isCustomRenderer && !Objects.isNull(this.mjs$renderByItemCallback)) {
                return new RenderArmorItem((ArmorMaterial)this.armorTier, this.armorType, this.createItemProperties(), this.attributes, this){

                    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
                        super.initializeClient(consumer);
                        consumer.accept(new KJSClientItemExtensions(mjs$renderByItemCallback){

                            @NotNull
                            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                                return super.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, original);
                            }
                        });
                    }
                };
            }
            return new RenderArmorItem((ArmorMaterial)this.armorTier, this.armorType, this.createItemProperties(), (Multimap<ResourceLocation, AttributeModifier>)this.attributes, this);
        }
    }

    public static class Boots
    extends Builder {
        public Boots(ResourceLocation i) {
            super(i, ArmorItem.Type.BOOTS);
        }
    }

    public static class Leggings
    extends Builder {
        public Leggings(ResourceLocation i) {
            super(i, ArmorItem.Type.LEGGINGS);
        }
    }

    public static class Chestplate
    extends Builder {
        public Chestplate(ResourceLocation i) {
            super(i, ArmorItem.Type.CHESTPLATE);
        }
    }

    public static class Helmet
    extends Builder {
        public Helmet(ResourceLocation i) {
            super(i, ArmorItem.Type.HELMET);
        }
    }
}

