/*
 * Decompiled with CFR 0.152.
 */
package com.anningui.modifyjs.util.js_long;

import dev.latvian.mods.kubejs.typings.Info;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

@Info(value="This class demonstrates the use of the SwitchMap utility to map various static constants to specific values. \nThe class provides three examples of how to use SwitchMap with:\n \n 1. A class containing static constants of different types (String, Integer, Double).\n 2. A class with only one type of static constants (Integer).\n 3. An Enum type that represents different display contexts (ItemDisplayContext).\n \n The examples showcase how to efficiently map these constants to their corresponding values using SwitchMap \n with methods like caseOf and defaultCase. This approach offers a concise, efficient, and maintainable \n alternative to traditional switch-case statements.\n \n It also demonstrates how to handle default cases when no matching constant is found, ensuring robustness \n in different use cases. This class leverages Java's powerful enum and constant handling to efficiently manage \n the mapping of static values to results.\n")
public class SwitchMap<T, V> {
    private final Map<T, Function<T, V>> cases = new HashMap<T, Function<T, V>>();
    private final Function<T, V> defaultCase;

    private SwitchMap(Map<T, Function<T, V>> cases, Function<T, V> defaultCase) {
        this.cases.putAll(cases);
        this.defaultCase = defaultCase;
    }

    @SafeVarargs
    public static <T, V> SwitchMap<T, V> of(Case<T, V> defaultCase, Case<T, V> ... cases) {
        HashMap<T, Function<T, V>> caseMap = new HashMap<T, Function<T, V>>();
        for (Case<T, V> caseItem : cases) {
            caseMap.put(caseItem.constantValue(), caseItem.value());
        }
        return new SwitchMap(caseMap, defaultCase.value());
    }

    @SafeVarargs
    public static <T extends Enum<T>, V> SwitchMap<T, V> ofEnum(Case<T, V> defaultCase, Case<T, V> ... cases) {
        EnumMap caseMap = new EnumMap(((Enum)cases[0].constantValue()).getClass());
        for (Case<T, V> caseItem : cases) {
            caseMap.put((Enum)caseItem.constantValue(), caseItem.value());
        }
        return new SwitchMap(caseMap, defaultCase.value());
    }

    public V get(T constantValue) {
        Function<T, V> result = this.cases.get(constantValue);
        if (result != null) {
            return result.apply(constantValue);
        }
        return this.defaultCase.apply(constantValue);
    }

    public static <T, V> Case<T, V> defOf(Function<T, V> supplier) {
        return new Case<Object, V>(null, supplier);
    }

    public static <T, V> Case<T, V> caseOf(T constantValue, V value) {
        return new Case<Object, Object>(constantValue, e -> value);
    }

    public record Case<T, V>(T constantValue, Function<T, V> value) {
    }
}

