/*
 * Decompiled with CFR 0.152.
 */
package com.anningui.modifyjs.util.js_long;

import java.util.function.Consumer;
import java.util.function.Function;

public class TryCatchPipe {
    private final Function<Void, ?> successAction;
    private final Function<Exception, ?> errorAction;
    private final Function<Void, ?> finallyAction;
    private final boolean hasReturnValue;
    private final boolean hasFinally;

    public TryCatchPipe(Function<Void, ?> successAction, Function<Exception, ?> errorAction, Function<Void, ?> finallyAction, boolean hasReturnValue, boolean hasFinally) {
        this.successAction = successAction;
        this.errorAction = errorAction;
        this.finallyAction = finallyAction;
        this.hasReturnValue = hasReturnValue;
        this.hasFinally = hasFinally;
    }

    public Object run() {
        if (this.hasFinally) {
            try {
                if (this.hasReturnValue) {
                    Object obj = this.successAction.apply(null);
                    return obj;
                }
                this.successAction.apply(null);
                Object var1_2 = null;
                return var1_2;
            }
            catch (Exception e) {
                if (this.hasReturnValue) {
                    Object obj = this.errorAction.apply(e);
                    return obj;
                }
                this.errorAction.apply(e);
                Object var2_6 = null;
                return var2_6;
            }
            finally {
                this.finallyAction.apply(null);
            }
        }
        try {
            if (this.hasReturnValue) {
                return this.successAction.apply(null);
            }
            this.successAction.apply(null);
            return null;
        }
        catch (Exception e) {
            if (this.hasReturnValue) {
                return this.errorAction.apply(e);
            }
            this.errorAction.apply(e);
            return null;
        }
    }

    public static TryCatchPipe pipeWithVoid(Runnable successAction, Consumer<Exception> errorAction) {
        return new TryCatchPipe(v -> {
            successAction.run();
            return null;
        }, e -> {
            errorAction.accept((Exception)e);
            return null;
        }, v -> null, false, false);
    }

    public static <T> TryCatchPipe pipeWithReturnValue(Function<Void, T> successAction, Function<Exception, T> errorAction) {
        return new TryCatchPipe(successAction, errorAction, v -> null, true, false);
    }

    public static <T> TryCatchPipe pipeWithReturnValueAndFinally(Function<Void, T> successAction, Function<Exception, T> errorAction, Runnable finallyAction) {
        return new TryCatchPipe(successAction, errorAction, v -> {
            finallyAction.run();
            return null;
        }, true, true);
    }

    public static TryCatchPipe pipeWithVoidAndFinally(Runnable successAction, Consumer<Exception> errorAction, Runnable finallyAction) {
        return new TryCatchPipe(v -> {
            successAction.run();
            return null;
        }, e -> {
            errorAction.accept((Exception)e);
            return null;
        }, v -> {
            finallyAction.run();
            return null;
        }, false, true);
    }

    public static void tryCatchBBV(boolean b, Runnable successAction, Runnable superAction) {
        if (b) {
            TryCatchPipe.pipeWithVoid(successAction, e -> superAction.run()).run();
        } else {
            superAction.run();
        }
    }

    public static <T> T tryCatchBBR(boolean b, Function<Void, T> successAction, Function<Exception, T> superAction) {
        if (b) {
            return (T)TryCatchPipe.pipeWithReturnValue(successAction, superAction).run();
        }
        return superAction.apply(null);
    }
}

