/*
 * Decompiled with CFR 0.152.
 */
package com.anningui.modifyjs.util.render;

import com.anningui.modifyjs.util.RayTraceResultMJS;
import com.anningui.modifyjs.util.js_long.TryCatchPipe;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class MJSRenderUtils {
    private static final Minecraft mc = Minecraft.m_91087_();

    @Info(value="@author Flander923\n\n@link <a href=\"https://www.bilibili.com/video/BV1t1AUe7ErD?vd_source=a6e9e72f334103d28476ce3f30850f61\">...</a>\n")
    public static void renderModelLists(ItemRenderer itemRenderer, BakedModel model, ItemStack stack, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        for (BakedModel bakedModel : model.getRenderPasses(stack, true)) {
            for (RenderType renderType : model.getRenderTypes(stack, true)) {
                VertexConsumer vertexConsumer = stack.m_41790_() ? ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)true) : ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)false);
                itemRenderer.m_115189_(bakedModel, stack, packedLight, packedOverlay, poseStack, vertexConsumer);
            }
        }
    }

    @Info(value="@author Lat\n\n@link <a href=\"https://github.com/FTBTeam/FTB-Jar-Mod/blob/main/src/main/java/dev/ftb/mods/ftbjarmod/block/entity/render/JarBlockEntityRenderer.java\">...</a>\n")
    public static void renderFluidModel(FluidStack fluidStack, float fluidScale, PoseStack poseStack, MultiBufferSource bufferSource, int light, int packedOverlay) {
        mc.m_91097_().m_174784_(InventoryMenu.f_39692_);
        VertexConsumer builder = bufferSource.m_6299_(RenderType.m_110466_());
        TextureAtlasSprite sprite = (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getStillTexture(fluidStack));
        Matrix4f m = poseStack.m_85850_().m_252922_();
        Matrix3f n = poseStack.m_85850_().m_252943_();
        int color = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid()).getTintColor(fluidStack);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = 1.0f;
        float s0 = 0.2f;
        float s1 = 1.0f - s0;
        float y0 = 0.0125f;
        float y1 = (0.2f + 12.6f * fluidScale) / 16.0f;
        float u0 = sprite.m_118367_(3.0);
        float v0 = sprite.m_118411_();
        float u1 = sprite.m_118367_(13.0);
        float v1 = sprite.m_118393_((double)(y1 * 16.0f));
        float u0top = sprite.m_118367_(3.0);
        float v0top = sprite.m_118393_(3.0);
        float u1top = sprite.m_118367_(13.0);
        float v1top = sprite.m_118393_(13.0);
        builder.m_252986_(m, s0, y1, s0).m_85950_(r, g, b, a).m_7421_(u0top, v0top).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y1, s1).m_85950_(r, g, b, a).m_7421_(u0top, v1top).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y1, s1).m_85950_(r, g, b, a).m_7421_(u1top, v1top).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y1, s0).m_85950_(r, g, b, a).m_7421_(u1top, v0top).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y0, s0).m_85950_(r, g, b, a).m_7421_(u0top, v0top).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y0, s0).m_85950_(r, g, b, a).m_7421_(u1top, v0top).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y0, s1).m_85950_(r, g, b, a).m_7421_(u1top, v1top).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y0, s1).m_85950_(r, g, b, a).m_7421_(u0top, v1top).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y1, s1).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y0, s1).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y0, s1).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y1, s1).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y1, s0).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y1, s0).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y0, s0).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y0, s0).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y1, s0).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y0, s0).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y0, s1).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s0, y1, s1).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y1, s0).m_85950_(r, g, b, a).m_7421_(u0, v0).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y1, s1).m_85950_(r, g, b, a).m_7421_(u1, v0).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y0, s1).m_85950_(r, g, b, a).m_7421_(u1, v1).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_252986_(m, s1, y0, s0).m_85950_(r, g, b, a).m_7421_(u0, v1).m_86008_(packedOverlay).m_85969_(light).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderLineIn3D(Vec3 start, Vec3 end, int startColor, int endColor, PoseStack poseStack, MultiBufferSource bufferSource) {
        Matrix4f m = poseStack.m_85850_().m_252922_();
        Matrix3f n = poseStack.m_85850_().m_252943_();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        vertexConsumer.m_252986_(m, (float)start.f_82479_, (float)start.f_82480_, (float)start.f_82481_).m_193479_(startColor).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(m, (float)end.f_82479_, (float)end.f_82480_, (float)end.f_82481_).m_193479_(endColor).m_252939_(n, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    @Deprecated
    public static BakedModel getModel(ResourceLocation idPath) {
        return mc.m_91304_().getModel(idPath);
    }

    @Deprecated
    public static BakedModel getModel(ResourceLocation idPath, String variant) {
        return mc.m_91304_().m_119422_(new ModelResourceLocation(idPath, variant));
    }

    public static BakedModel getJsonModel(ResourceLocation idPath) {
        return mc.m_91304_().m_119422_(new ModelResourceLocation(idPath, "standalone"));
    }

    public static BakedModel getJsonModel(ResourceLocation idPath, String variant) {
        return mc.m_91304_().m_119422_(new ModelResourceLocation(idPath, variant));
    }

    public static <T extends LivingEntity> Optional<EntityModel<T>> getEntityModel(T entity) {
        if (entity != null) {
            EntityRenderer renderer = mc.m_91290_().m_114382_(entity);
            try {
                return Optional.of(((LivingEntityRenderer)renderer).m_7200_());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static <T extends LivingEntity> Optional<HumanoidModel<T>> getHumanoidModel(T entity) {
        if (entity != null) {
            EntityRenderer renderer = mc.m_91290_().m_114382_(entity);
            try {
                return Optional.of((HumanoidModel)((LivingEntityRenderer)renderer).m_7200_());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static <T extends LivingEntity> boolean isHumanoidModel(T entity) {
        if (entity != null) {
            EntityRenderer renderer = mc.m_91290_().m_114382_(entity);
            return renderer instanceof LivingEntityRenderer && ((LivingEntityRenderer)renderer).m_7200_() instanceof HumanoidModel;
        }
        return false;
    }

    public static <T extends LivingEntity> void runOnHumanoidModel(T entity, Consumer<HumanoidModel<T>> consumer) {
        TryCatchPipe.tryCatchBBV(MJSRenderUtils.isHumanoidModel(entity), () -> consumer.accept(MJSRenderUtils.getHumanoidModel(entity).orElse(null)), () -> {});
    }

    public static HumanoidModel<AbstractClientPlayer> getPlayerModel(AbstractClientPlayer player) {
        if (player != null) {
            EntityRenderer renderer = mc.m_91290_().m_114382_((Entity)player);
            return (HumanoidModel)((PlayerRenderer)renderer).m_7200_();
        }
        return null;
    }

    public static void renderEntityLineIn3D(Entity entity, float rayLength, int startColor, int endColor, PoseStack poseStack, MultiBufferSource bufferSource) {
        float yaw = entity.m_146908_();
        float pitch = entity.m_146909_();
        double pi = Math.PI;
        double yawRad = (double)yaw * (pi / 180.0);
        double pitchRad = (double)pitch * (pi / 180.0);
        double x = -Math.sin(yawRad) * Math.cos(pitchRad);
        double y = -Math.sin(pitchRad);
        double z = Math.cos(yawRad) * Math.cos(pitchRad);
        float endX = (float)x * rayLength;
        float endY = (float)y * rayLength;
        float endZ = (float)z * rayLength;
        MJSRenderUtils.renderLineIn3D(new Vec3(0.0, 0.0, 0.0), new Vec3((double)endX, (double)endY, (double)endZ), startColor, endColor, poseStack, bufferSource);
    }

    @Info(value="@param r 0~255\n\n@param g 0~255\n\n@param b 0~255\n\n@param a 0~1\n")
    public static int rgba255ToColor(int r, int g, int b, float a) {
        int alpha = (int)(a * 255.0f);
        alpha = Math.max(0, Math.min(255, alpha));
        return (alpha & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static RayTraceResultMJS getPlayerRayTrace(Player player, double distance) {
        Vec3 lookVec = player.m_20154_();
        Vec3 playerPos = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_());
        Vec3 endPos = playerPos.m_82520_(lookVec.f_82479_ * distance, lookVec.f_82480_ * distance, lookVec.f_82481_ * distance);
        return new RayTraceResultMJS(playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, endPos.f_82479_, endPos.f_82480_, endPos.f_82481_, new Vec3(playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_), new Vec3(endPos.f_82479_, endPos.f_82480_, endPos.f_82481_), new Vec3(lookVec.f_82479_, lookVec.f_82480_, lookVec.f_82481_));
    }
}

